<?php

namespace App;

/**
 * Theme Customization - header
 */

// Sections
$panels[] = array(
	'id' => 'muy_header',
	'title' => __('Header', 'muy-lindo'),
	'priority' => '48',
	'description' => __('Configure header section.', 'muy-lindo')
);

$sections[] = array(
	'id' => 'muy_header_options',
	'title' => __('Header Options', 'muy-lindo'),
	'priority' => '50',
	'panel' => 'muy_header',
	'description' => __('Configure the header section.', 'muy-lindo')
);

$options['muy_header_type'] = array(
	'id' => 'muy_header_type',
	'label'   => __('Header type', 'muy-lindo'),
	'section' => 'muy_header_options',
	'type'    => 'select',
	'default' => 'header-1',
	'choices' => array(
		'header-1' => __('Logo on the left - Menu centered', 'muy-lindo'),
		'header-2' => __('Logo Centered - Menu on the left', 'muy-lindo'),
		'header-3' => __('Logo on the left - Menu on the right', 'muy-lindo'),
	),
);

$options['muy_header_width'] = array(
	'id' => 'muy_header_width',
	'label'   => __('Header width', 'muy-lindo'),
	'section' => 'muy_header_options',
	'type'    => 'select',
	'default' => '',
	'choices' => array(
		'1024px' => __('Small', 'muy-lindo'),
		'' => __('Default', 'muy-lindo'),
		'100%' => __('Full Width', 'muy-lindo'),
	),
);

$options['muy_header_scroll_hide'] = array(
	'id' => 'muy_header_scroll_hide',
	'label'   => __('Abilita scomparsa header allo scroll', 'muy-lindo'),
	'description' => __("Scegli se nascondere l'header quando si effettua lo scroll", 'muy-lindo'),
	'section' => 'muy_header_options',
	'type'    => 'checkbox',
	'default' => 0,
);

$options['muy_header_transparent'] = array(
	'id' => 'muy_header_transparent',
	'label'   => __('Abilita il background trasparente', 'muy-lindo'),
	'description' => __("Rimuovi il background dell'header", 'muy-lindo'),
	'section' => 'muy_header_options',
	'type'    => 'checkbox',
	'default' => 0,
);

$options['muy_header_fixed'] = array(
	'id' => 'muy_header_fixed',
	'label'   => __('Toggle Header fixed', 'muy-lindo'),
	'description' => __('Choose if the header is always visible or not', 'muy-lindo'),
	'section' => 'muy_header_options',
	'type'    => 'checkbox',
	'default' => 0,
);

$options['muy_without_header'] = array(
	'id' => 'muy_without_header',
	'label'   => __('Disable Header', 'muy-lindo'),
	'description' => __('Choose whether to hide the header or not', 'muy-lindo'),
	'section' => 'muy_header_options',
	'type'    => 'checkbox',
	'default' => 0,
);

$options['muy_header_logo'] = array(
	'id' => 'muy_header_logo',
	'label'   => __('Logo', 'muy-lindo'),
	'section' => 'muy_header_options',
	'type'    => 'image',
);
$options['muy_header_logo_Secondary'] = array(
	'id' => 'muy_header_logo_secondary',
	'label'   => __('Logo Secondary', 'muy-lindo'),
	'section' => 'muy_header_options',
	'type'    => 'image',
);

$options['muy_header_search_toggle'] = array(
	'id' => 'muy_header_search_toggle',
	'label'   => __('Toggle Search Button', 'muy-lindo'),
	'default' => true,
	'description' => __('Show/hide search icon in header', 'muy-lindo'),
	'section' => 'muy_header_options',
	'type'    => 'checkbox',
);

$options['muy_header_overlay_menu_toggle'] = array(
	'id' => 'muy_header_overlay_menu_toggle',
	'label'   => __('Toggle menu hamburger in header', 'muy-lindo'),
	'default' => true,
	'description' => __('Show/hide menu hamburger in header on desktop', 'muy-lindo'),
	'section' => 'muy_header_options',
	'type'    => 'checkbox',
);

$options['muy_header_overlay_menu_toggle_mobile'] = array(
	'id' => 'muy_header_overlay_menu_toggle_mobile',
	'label'   => __('Toggle menu hamburger in header mobile', 'muy-lindo'),
	'default' => true,
	'description' => __('Show/hide menu hamburger in header on mobile', 'muy-lindo'),
	'section' => 'muy_header_options',
	'type'    => 'checkbox',
);

$sections[] = array(
	'id' => 'muy_header_colors',
	'title' => __('Header Colors', 'muy-lindo'),
	'priority' => '55',
	'panel' => 'muy_header',
	'description' => __('Configure header colors.', 'muy-lindo')
);

$options['muy_header_background_color'] = array(
	'id' => 'muy_header_background_color',
	'label'   => __('Background Color', 'muy-lindo'),
	'default' => muy_default_color('side'),
	'description' => __('Choose the background color of the header', 'muy-lindo'),
	'section' => 'muy_header_colors',
	'type'    => 'color',
);

$options['muy_header_link_color'] = array(
	'id' => 'muy_header_link_color',
	'label'   => __('Text Color', 'muy-lindo'),
	'section' => 'muy_header_colors',
	'default' => muy_default_color('main'),
	'description' => __('Choose the color of the link in the menu', 'muy-lindo'),
	'type'    => 'color',
);

$options['muy_header_button_background_color'] = array(
	'id' => 'muy_header_button_background_color',
	'label'   => __('Buttons Background Color', 'muy-lindo'),
	'default' => muy_default_color('side'),
	'description' => __('Choose the background color of the buttons', 'muy-lindo'),
	'section' => 'muy_header_colors',
	'type'    => 'color',
);

$options['muy_header_button_invert_color'] = array(
	'id' => 'muy_header_button_invert_color',
	'label'   => __('Buttons invert Color', 'muy-lindo'),
	'default' => muy_default_color('main'),
	'description' => __('Choose the invert color of the buttons - ONLY FOR THE INVERT STYLE', 'muy-lindo'),
	'section' => 'muy_header_colors',
	'type'    => 'color',
);

$options['muy_header_button_link_color'] = array(
	'id' => 'muy_header_button_link_color',
	'description' => __('Choose the color of the buttons text', 'muy-lindo'),
	'default' => muy_default_color('main'),
	'label'   => __('Buttons Text Color', 'muy-lindo'),
	'section' => 'muy_header_colors',
	'type'    => 'color',
);


$options['muy_header_search_color'] = array(
	'id' => 'muy_header_search_color',
	'label'   => __('Search Icon Color', 'muy-lindo'),
	'default' => muy_default_color('main'),
	'description' => __('Choose the color of the search button', 'muy-lindo'),
	'section' => 'muy_header_colors',
	'type'    => 'color',
);

$options['muy_header_menu_color'] = array(
	'id' => 'muy_header_menu_color',
	'label'   => __('Menu Icon Color', 'muy-lindo'),
	'default' => muy_default_color('main'),
	'description' => __('Choose the color of the menu icon', 'muy-lindo'),
	'section' => 'muy_header_colors',
	'type'    => 'color',
);
