<?php

namespace App;

/**
 * Theme Customization - header
 */

// Sections

$panels[] = array(
	'id' => 'muy_overlay',
	'title' => __('Overlay', 'muy-lindo'),
	'priority' => '50'
);

$sections[] = array(
	'id' => 'muy_overlay_options',
	'title' => __('Overlay Options', 'muy-lindo'),
	'priority' => '50',
	'panel' => 'muy_overlay',
	'description' => __('Configure the overlay section.', 'muy-lindo')
);

$options['muy_overlay_type'] = array(
	'id' => 'muy_overlay_type',
	'label'   => __('Overlay menu type', 'muy-lindo'),
	'description'   => __('The overlays menu are customizable in the widget section', 'muy-lindo'),
	'section' => 'muy_overlay_options',
	'type'    => 'select',
	'default' => 'overlay-1',
	'choices' => array(
		'overlay-1' => __('2 Menus with different sizes', 'muy-lindo'),
		'overlay-2' => __('4 Menus with same size', 'muy-lindo'),
	),
);

$sections[] = array(
	'id' => 'muy_overlay_colors',
	'title' => __('Overlay Colors', 'muy-lindo'),
	'priority' => '50',
	'panel' => 'muy_overlay',
	'description' => __('Configure the overlay section colors.', 'muy-lindo')
);

$options['muy_overlay_background_color'] = array(
	'id' => 'muy_overlay_background_color',
	'label'   => __('Background Color', 'muy-lindo'),
	'default' => muy_default_color('main'),
	'description' => __('Choose the background color of the overlay.', 'muy-lindo'),
	'section' => 'muy_overlay_colors',
	'type'    => 'color',
);

$options['muy_overlay_link_color'] = array(
	'id' => 'muy_overlay_link_color',
	'label'   => __('Text color', 'muy-lindo'),
	'default' => muy_default_color('side'),
	'description' => __('Choose the text color of the link in the overlay.', 'muy-lindo'),
	'section' => 'muy_overlay_colors',
	'type'    => 'color',
);
$options['muy_overlay_menu_button_color'] = array(
	'id' => 'muy_overlay_menu_button_color',
	'label'   => __('Icon Menu when open color', 'muy-lindo'),
	'default' => muy_default_color('side'),
	'description' => __('Choose the color of the Menu icon when the overlay is open.', 'muy-lindo'),
	'section' => 'muy_overlay_colors',
	'type'    => 'color',
);
$options['muy_overlay_decoration_color'] = array(
	'id' => 'muy_overlay_decoration_color',
	'label'   => __('Decoration Color', 'muy-lindo'),
	'default' => muy_default_color('side'),
	'description' => __('Choose the color of all the other decorations present in the overlay', 'muy-lindo'),
	'section' => 'muy_overlay_colors',
	'type'    => 'color',
);
$options['muy_overlay_button_color'] = array(
	'id' => 'muy_overlay_button_color',
	'label'   => __('Button Background Color', 'muy-lindo'),
	'default' => muy_default_color('side'),
	'description' => __('Choose the background color of the buttons in the overlay.', 'muy-lindo'),
	'section' => 'muy_overlay_colors',
	'type'    => 'color',
);
$options['muy_overlay_button_text_color'] = array(
	'id' => 'muy_overlay_button_text_color',
	'label'   => __('Button Text color', 'muy-lindo'),
	'description' => __('Choose the text color of the buttons in the overlay.', 'muy-lindo'),
	'section' => 'muy_overlay_colors',
	'type'    => 'color',
);

$options['muy_overlay_social_color'] = array(
	'id' => 'muy_overlay_social_color',
	'label'   => __('Social icons Color', 'muy-lindo'),
	'default' => muy_default_color('side'),
	'description' => __('Choose the color of the Social Icons', 'muy-lindo'),
	'section' => 'muy_overlay_colors',
	'type'    => 'color',
);



?>