<?php

namespace App;

/**
 * Theme Customization - colors
 */

$panels[] = array(
	'id' => 'muy_posts',
	'title' => __('Posts', 'muy-lindo'),
	'priority' => '51',
	'description' => __('Configure posts archive and single page.', 'muy-lindo')
);


$sections[] = array(
	'id' => 'muy_posts_options_teaser',
	'title' => __('Posts Teaser', 'muy-lindo'),
	'priority' => '52',
	'panel' => 'muy_posts',
	'description' => __('Configure posts archive and single page.', 'muy-lindo')
);

$options['muy_posts_teaser_per_row'] = array(
	'id' => 'muy_posts_teaser_per_row',
	'label'   => __('Teaser per row', 'muy-lindo'),
	'section' => 'muy_posts_options_teaser',
	'type'    => 'select',
	'default' => '1',
	'choices' => array(
		'1' => __('1 post per row', 'muy-lindo'),
		'2' => __('2 posts per row', 'muy-lindo'),
		'3' => __('3 posts per row', 'muy-lindo'),
		'4' => __('4 posts per row', 'muy-lindo'),
	),
);

$options['muy_posts_teaser_image_height'] = array(
	'id' => 'muy_posts_teaser_image_height',
	'label'   => __('Teaser image height', 'muy-lindo'),
	'section' => 'muy_posts_options_teaser',
	'type'    => 'select',
	'default' => 'muy-height-md',
	'choices' => array(
		'muy-height-lg' => __('Tall', 'muy-lindo'),
		'muy-height-md' => __('Medium', 'muy-lindo'),
		'muy-height-sm' => __('Short', 'muy-lindo'),
	),
);

$options['muy_posts_teaser_image_toggle'] = array(
	'id' => 'muy_posts_teaser_image_toggle',
	'label'   => __('Toggle the teaser image', 'muy-lindo'),
	'description'   => __('Show/hide image in post teaser', 'muy-lindo'),
	'section' => 'muy_posts_options_teaser',
	'type'    => 'checkbox',
	'default' => true,
);

$options['muy_posts_teaser_image_placeholder'] = array(
	'id' => 'muy_posts_teaser_image_placeholder',
	'label'   => __('Teaser image placeholder', 'muy-lindo'),
	'description'   => __('Choose image placeholder in teaser if post doesn\'t have one', 'muy-lindo'),
	'section' => 'muy_posts_options_teaser',
	'type'    => 'media',
);

$options['muy_posts_teaser_excerpt_toggle'] = array(
	'id' => 'muy_posts_teaser_excerpt_toggle',
	'label'   => __('Teaser toggle excerpt ', 'muy-lindo'),
	'description'   => __('Show/hide excerpt in post teaser', 'muy-lindo'),
	'section' => 'muy_posts_options_teaser',
	'type'    => 'checkbox',
	'default' => true,
);

$options['muy_posts_teaser_date_toggle'] = array(
	'id' => 'muy_posts_teaser_date_toggle',
	'label'   => __('Toggle the data', 'muy-lindo'),
	'description'   => __('Show/hide date in post teaser', 'muy-lindo'),
	'section' => 'muy_posts_options_teaser',
	'type'    => 'checkbox',
	'default' => true,
);

$options['muy_posts_teaser_category_toggle'] = array(
	'id' => 'muy_posts_teaser_category_toggle',
	'label'   => __('Toggle the category', 'muy-lindo'),
	'description'   => __('Show/hide category in post teaser', 'muy-lindo'),
	'section' => 'muy_posts_options_teaser',
	'type'    => 'checkbox',
	'default' => true,
);

$options['muy_posts_teaser_showmore'] = array(
	'id' => 'muy_posts_teaser_showmore',
	'label'   => __('Teaser Show More Button', 'muy-lindo'),
	'section' => 'muy_posts_options_teaser',
	'type'    => 'select',
	'default' => 'hidden',
	'choices' => array(
		'hidden' => __('Don\'t show', 'muy-lindo'),
		'underline block' => __('Link', 'muy-lindo'),
		'btn' => __('Button', 'muy-lindo'),
		'btn invert' => __('Inverted button', 'muy-lindo'),
	),
);

$sections[] = array(
	'id' => 'muy_post_teaser_colors',
	'title' => __('Post Teaser Colors', 'muy-lindo'),
	'priority' => '55',
	'panel' => 'muy_posts',
	'description' => __('Configure Post Teaser colors.', 'muy-lindo')
);

$options['muy_posts_teaser_title_color'] = array(
	'id' => 'muy_posts_teaser_title_color',
	'label'   => __('Teaser title color', 'muy-lindo'),
	'default' => muy_default_color('main'),
	'description'   => __('Choose the color of the title', 'muy-lindo'),
	'section' => 'muy_post_teaser_colors',
	'type'    => 'color',
);

$options['muy_posts_teaser_excerpt_color'] = array(
	'id' => 'muy_posts_teaser_excerpt_color',
	'label'   => __('Teaser excerpt color', 'muy-lindo'),
	'default' => muy_default_color('main'),
	'description'   => __('Choose the color of the excerpt', 'muy-lindo'),
	'section' => 'muy_post_teaser_colors',
	'type'    => 'color',
);


?>