<?php

namespace App;

/**
 * Theme Customization - colors
 */

$plural_name = get_field('product_plural_name', 'options') ?: 'Products';
$singular_name = get_field('product_singular_name', 'options') ?: 'Product';

$panels[] = array(
	'id' => 'muy_products',
	'title' => sprintf(__('%s', 'muy-lindo'), $plural_name),
	'priority' => '52',
	'description' => __('Configure Products teaser and single page.', 'muy-lindo')
);
$sections[] = array(
	'id' => 'muy_products_options_teaser',
	'title' => sprintf(__('%s Teaser', 'muy-lindo'), $plural_name),
	'priority' => '52',
	'panel' => 'muy_products',
	'description' => sprintf(__('Configure %s teaser and single page.', 'muy-lindo'), $plural_name),
);

$options['muy_products_teaser_per_row'] = array(
	'id' => 'muy_products_teaser_per_row',
	'label'   => sprintf(__('%s teaser per row', 'muy-lindo'), $plural_name),
	'section' => 'muy_products_options_teaser',
	'type'    => 'select',
	'default' => '1',
	'choices' => array(
		'1' => sprintf(__('1 %s per row', 'muy-lindo'), $singular_name),
		'2' => sprintf(__('2 %s per row', 'muy-lindo'), $plural_name),
		'3' => sprintf(__('3 %s per row', 'muy-lindo'), $plural_name),
		'4' => sprintf(__('4 %s per row', 'muy-lindo'), $plural_name),
	),
);

$options['muy_products_teaser_image_height'] = array(
	'id' => 'muy_products_teaser_image_height',
	'label'   => __('Teaser image height', 'muy-lindo'),
	'section' => 'muy_products_options_teaser',
	'type'    => 'select',
	'default' => 'muy-height-md',
	'choices' => array(
		'muy-height-lg' => __('Tall', 'muy-lindo'),
		'muy-height-md' => __('Medium', 'muy-lindo'),
		'muy-height-sm' => __('Short', 'muy-lindo'),
	),
);

$options['muy_products_teaser_image_toggle'] = array(
	'id' => 'muy_products_teaser_image_toggle',
	'label'   => __('Toggle the teaser image', 'muy-lindo'),
	'description'   => sprintf(__('Show/hide image in %s teaser', 'muy-lindo'), $plural_name),
	'section' => 'muy_products_options_teaser',
	'default' => true,
	'type'    => 'checkbox',
);

$options['muy_products_teaser_image_placeholder'] = array(
	'id' => 'muy_products_teaser_image_placeholder',
	'label'   => __('Teaser image placeholder', 'muy-lindo'),
	'description'   => __('Choose image placeholder in teaser if '. $plural_name .' doesn\'t have one', 'muy-lindo'),
	'section' => 'muy_products_options_teaser',
	'type'    => 'media',
);

$options['muy_products_text_alignment'] = array(
	'id' => 'muy_products_text_alignment',
	'label'   => __('Teaser text alignment', 'muy-lindo'),
	'section' => 'muy_products_options_teaser',
	'type'    => 'select',
	'default' => 'left',
	'choices' => array(
		'left' => __('Left', 'muy-lindo'),
		'center' => __('Center', 'muy-lindo'),
		'right' => __('Right', 'muy-lindo'),
	),
);

$options['muy_products_teaser_excerpt_toggle'] = array(
	'id' => 'muy_products_teaser_excerpt_toggle',
	'label'   => __('Teaser toggle excerpt', 'muy-lindo'),
	'description'   => sprintf(__('Show/hide excerpt in %s teaser', 'muy-lindo'), $plural_name),
	'section' => 'muy_products_options_teaser',
	'type'    => 'checkbox',
	'default' => true,
);

$options['muy_products_teaser_category_toggle'] = array(
	'id' => 'muy_products_teaser_category_toggle',
	'label'   => sprintf(__('Toggle %s category', 'muy-lindo'), $plural_name),
	'description'   => sprintf(__('Show/hide category in %s teaser', 'muy-lindo'), $singular_name),
	'section' => 'muy_products_options_teaser',
	'type'    => 'checkbox',
	'default' => true,
);

$options['muy_products_teaser_showmore'] = array(
	'id' => 'muy_products_teaser_showmore',
	'label'   => __('Teaser Show More Button', 'muy-lindo'),
	'section' => 'muy_products_options_teaser',
	'type'    => 'select',
	'default' => 'hidden',
	'choices' => array(
		'hidden' => __('Don\'t show', 'muy-lindo'),
		'underline block' => __('Link', 'muy-lindo'),
		'btn' => __('Button', 'muy-lindo'),
		'btn invert' => __('Inverted button', 'muy-lindo'),
	),
);

$sections[] = array(
	'id' => 'muy_products_teaser_colors',
	'title' => sprintf(__('%s Teaser Colors', 'muy-lindo'), $plural_name),
	'priority' => '55',
	'panel' => 'muy_products',
	'description' => sprintf(__('Configure %s Teaser colors.', 'muy-lindo'), $singular_name),
);

$options['muy_products_teaser_title_color'] = array(
	'id' => 'muy_products_teaser_title_color',
	'label'   => __('Teaser title color', 'muy-lindo'),
	'default' => muy_default_color('main'),
	'description'   => __('Choose the color of the title', 'muy-lindo'),
	'section' => 'muy_products_teaser_colors',
	'type'    => 'color',
);

$options['muy_products_teaser_excerpt_color'] = array(
	'id' => 'muy_products_teaser_excerpt_color',
	'label'   => __('Teaser excerpt color', 'muy-lindo'),
	'default' => muy_default_color('main'),
	'description'   => __('Choose the color of the excerpt', 'muy-lindo'),
	'section' => 'muy_products_teaser_colors',
	'type'    => 'color',
);

?>