<?php

namespace App;

/**
 * Theme Customization - search
 */

// Sections
$panels[] = array(
	'id' => 'muy_search',
	'title' => __('Search', 'muy-lindo'),
	'priority' => '49',
	'description' => __('Configure search section.', 'muy-lindo')
);


$sections[] = array(
	'id' => 'muy_search_options',
	'title' => __('Search Option', 'muy-lindo'),
	'priority' => '50',
	'panel' => 'muy_search',
	'description' => __('Configure the search section.', 'muy-lindo')
);

$options['muy_search_button_style'] = array(
	'id' => 'muy_search_button_style',
	'label'   => __('Toggle Outline Button Style', 'muy-lindo'),
	'section' => 'muy_search_options',
	'description' => __('Choose between Outline or normal submit button style','muy-lindo'),
 	'type'    => 'select',
	'default' => 'btn',
	'choices' => array(
		'underline block' => __('Link', 'muy-lindo'),
		'btn' => __('Button', 'muy-lindo'),
		'btn-invert' => __('Inverted button', 'muy-lindo'),
	),
);

$sections[] = array(
	'id' => 'muy_search_colors',
	'title' => __('Search Colors', 'muy-lindo'),
	'priority' => '55',
	'panel' => 'muy_search',
	'description' => __('Configure search colors.', 'muy-lindo')
);

$options['muy_search_cross_color'] = array(
	'id' => 'muy_search_cross_color',
	'label'   => __('Search - Cross Icon color', 'muy-lindo'),
	'default' => muy_default_color('main'),
	'description' => __('Choose the color of the Cross icon', 'muy-lindo'),
	'section' => 'muy_search_colors',
	'type'    => 'color',
);

$options['muy_search_placeholder_text_color'] = array(
	'id' => 'muy_search_placeholder_text_color',
	'label'   => __('search - Placeholder Text Color', 'muy-lindo'),
	'section' => 'muy_search_colors',
	'default' => muy_default_color('main'),
	'description' => __('Choose the color of the text when is not typed in', 'muy-lindo'),
	'type'    => 'color',
);

$options['muy_search_text_color'] = array(
	'id' => 'muy_search_text_color',
	'label'   => __('search - Text Color', 'muy-lindo'),
	'section' => 'muy_search_colors',
	'default' => muy_default_color('main'),
	'description' => __('Choose the color of the text when typed in', 'muy-lindo'),
	'type'    => 'color',
);

$options['muy_search_button_background_color'] = array(
	'id' => 'muy_search_button_background_color',
	'label'   => __('search - Buttons Background Color', 'muy-lindo'),
	'default' => muy_default_color('main'),
	'description' => __('Choose the background color of the buttons', 'muy-lindo'),
	'section' => 'muy_search_colors',
	'type'    => 'color',
);

$options['muy_search_button_link_color'] = array(
	'id' => 'muy_search_button_link_color',
	'description' => __('Choose the color of the buttons text', 'muy-lindo'),
	'default' => muy_default_color('side'),
	'label'   => __('search - Buttons Text Color', 'muy-lindo'),
	'section' => 'muy_search_colors',
	'type'    => 'color',
);

$options['muy_search_button_invert_color'] = array(
	'id' => 'muy_search_button_invert_color',
	'default' => muy_default_color('main'),
	'label'   => __('search - Buttons invert Color', 'muy-lindo'),
	'description' => __('Choose the invert color of the buttons - ONLY FOR THE INVERT STYLE', 'muy-lindo'),
	'section' => 'muy_search_colors',
	'type'    => 'color',
);
