<?php

namespace App;

$muy_buttons_radius = get_theme_mod('muy_buttons_radius', 0);
$muy_buttons_invert_color = get_theme_mod('muy_buttons_invert_color', muy_default_color('main'));
$muy_buttons_backgroundcolor = get_theme_mod('muy_buttons_backgroundcolor', muy_default_color('main'));
$muy_buttons_text_color = get_theme_mod('muy_buttons_text_color', muy_default_color('main'));
$muy_body_background_color = get_theme_mod('muy_body_background_color', muy_default_color('side'));

$muy_header_footer_font_link = get_theme_mod('muy_header_footer_font_link');
$muy_header_footer_font_rule = get_theme_mod('muy_header_footer_font_rule', "font-family: 'Charter', serif");
$muy_body_font_link = get_theme_mod('muy_body_font_link');
$muy_body_font_rule = get_theme_mod('muy_body_font_rule', "font-family: 'Charter', serif");
$muy_titles_font_rule = get_theme_mod('muy_titles_font_rule', "font-family: 'Charter', serif");
$muy_titles_font_link = get_theme_mod('muy_titles_font_link');
$muy_body_text_color = get_theme_mod('muy_body_text_color', muy_default_color('main'));
$muy_buttons_height = get_theme_mod('muy_buttons_height', '0.75rem');
?>

<?= $muy_header_footer_font_link ?>
<?= $muy_body_font_link ?>
<?= $muy_titles_font_link ?>

<style type="text/css">
    body:not(.wp-admin) .btn,
    .btn-invert,
    .search-form-page .search-submit,
    .main-header ul li.btn a,
    .main-header ul li.btn-invert a,
    .overlay-search .search-submit,
    .gform_footer input {
        border-radius: <?= $muy_buttons_radius ?>px;
    }

    .btn-invert,
    .btn.invert {
        border-color: <?= $muy_buttons_invert_color ?>;
        color: <?= $muy_buttons_invert_color ?>;
    }

    a.btn,
    .search-form-page .search-submit,
    .gform_footer input {
        background-color: <?= $muy_buttons_backgroundcolor ?>;
    }

    .gform_footer input,
    a.btn {
        color: <?= $muy_buttons_text_color ?> !important;
    }

    a.btn.invert {
        color: <?= $muy_buttons_invert_color ?> !important;
    }

    body:not(.wp-admin) {
        background-color: <?= $muy_body_background_color ?> !important;
    }

    body:not(.wp-admin) header.main-header,
    body:not(.wp-admin) div#overlay-menu,
    body:not(.wp-admin) footer.main-footer {
        <?= $muy_header_footer_font_rule ?>;
    }

    body:not(.wp-admin) {
        <?= $muy_body_font_rule ?>;
    }

    .muy-font-primary {
        <?= $muy_titles_font_rule ?>;
    }

    .muy-font-secondary {
        <?= $muy_body_font_rule ?>;
    }

    body:not(.wp-admin) h1,
    body:not(.wp-admin) ol,
    body:not(.wp-admin) ul,
    body:not(.wp-admin) li,
    body:not(.wp-admin) h2,
    body:not(.wp-admin) h3,
    body:not(.wp-admin) h4,
    body:not(.wp-admin) h5,
    body:not(.wp-admin) h6,
    body:not(.wp-admin) title,
    body:not(.wp-admin) span {
        color: <?= $muy_body_text_color ?>;
        <?= $muy_titles_font_rule ?>;
    }

    body:not(.wp-admin) .button,
    .btn a,
    a.btn,
    .search-form-page .search-submit,
    .search-field,
    .btn-invert,
    .overlay-search .search-submit {
        padding-top: <?= $muy_buttons_height ?> !important;
        padding-bottom: <?= $muy_buttons_height ?> !important;
    }

    .overlay-search input.search-submit {
        padding-top: calc(<?= $muy_buttons_height ?> * 1.5) !important;
        padding-bottom: calc(<?= $muy_buttons_height ?> * 1.5) !important;
    }
</style>