<?php

namespace App;

$muy_header_menu_color = get_theme_mod('muy_header_menu_color', muy_default_color('main'));
$muy_header_link_color = get_theme_mod('muy_header_link_color', muy_default_color('main'));
$muy_header_background_color = get_theme_mod('muy_header_background_color', muy_default_color('side'));
$muy_header_button_invert_color = get_theme_mod('muy_header_button_invert_color', muy_default_color('main'));
$muy_header_search_color = get_theme_mod('muy_header_search_color', muy_default_color('main'));
$muy_header_button_background_color = get_theme_mod('muy_header_button_background_color', muy_default_color('main'));
$muy_header_button_link_color = get_theme_mod('muy_header_button_link_color', muy_default_color('side'));
$muy_header_fixed = get_theme_mod('muy_header_fixed');
$muy_header_width = get_theme_mod('muy_header_width');

$activate_toggle = get_theme_mod('muy_header_overlay_menu_toggle', true) ? 'display: inline-block;' : 'display: none';
$activate_toggle_mobile = get_theme_mod('muy_header_overlay_menu_toggle_mobile', true) ? 'display: inline-block;' : 'display: none';


if ($muy_header_fixed) {
    $activate_header_fixed = 'position: fixed';
    $wrap_spacing = 'padding-top: 104px';
}

?>

<style>
    div.wrap {
        padding-top: 66px;
    }

    .header-container {
        max-width: <?= $muy_header_width ?> !important;
    }

    header.main-header {
        <?= $activate_header_fixed ?>;
    }

    header.main-header,
    .search-form-wrapper .search-form-panel input,
    .overlay-search,
    .search-text,
    .overlay-search>div .search-submit {
        background-color: <?= $muy_header_background_color ?>;
    }

    .main-header ul li.btn a {
        color: <?= $muy_header_button_link_color ?> !important;
    }

    .main-header ul li.btn a {
        background-color: <?= $muy_header_button_background_color ?>;
        border-color: <?= $muy_header_button_invert_color ?> !important;
    }

    .main-header ul li.btn-invert a {
        color: <?= $muy_header_button_invert_color ?> !important;
    }

    span.hamburger-inner,
    span.hamburger-inner::after,
    span.hamburger-inner::before {
        background-color: <?= $muy_header_menu_color ?> !important;
    }

    div.search-icon svg path {
        fill: <?= $muy_header_search_color ?> !important;
    }

    button#overlay-menu-toggle {
        <?= $activate_toggle ?>;
    }

    @media screen and (max-width: 768px) {
        button#overlay-menu-toggle {
            <?= $activate_toggle_mobile ?>;
        }
    }

    @media screen and (min-width: 1024px) {
        div.wrap {
            padding-top: 104px;
        }
    }


    .main-header ul li.menu-item-has-children::after {
        border-top-color: <?= $muy_header_link_color ?> !important;
    }
</style>