<?php

namespace App;

function get_gutenberg_colors_matrix()
{
    return [
        [
            'default' => '',
        ],
        [
            'default' => '',
        ],
        [
            'default' => '',
        ],
        [
            'default' => '',
        ],
        [
            'default' => '',
        ],
        [
            'default' => '#000',
        ],
        [
            'default' => '#333',
        ],
        [
            'default' => '#999',
        ],
        [
            'default' => '#eee',
        ],
        [
            'default' => '#fff',
        ],
    ];
}


add_action('customize_controls_enqueue_scripts', function () {
    $colors =  get_gutenberg_colors_matrix();

    foreach ($colors as $number => $item) {
        if(!empty(get_theme_mod('muy_global_color_' . $number) ?: $item['default'])) {
            $color[] = get_theme_mod('muy_global_color_' . $number) ?: $item['default'];
        }
    }
    $color_palettes = json_encode($color);
    wp_add_inline_script('wp-color-picker', 'jQuery.wp.wpColorPicker.prototype.options.palettes = ' . $color_palettes . ';');
});

/**
 * Adds custom color palettes to wp.color picker.
 */


/**
 * Add <body> classes
 */
add_filter('body_class', function ($classes = []) {
    /** Add page slug if it doesn't exist */
    if (is_single() || is_page() && !is_front_page()) {
        if (!in_array(basename(get_permalink()), $classes)) {
            $classes[] = basename(get_permalink());
        }
    }

    /** Add class if sidebar is active */
    if (display_sidebar()) {
        $classes[] = 'sidebar-primary';
    }

    /** Clean up class names for custom templates */
    $classes = array_map(function ($class) {
        return preg_replace(['/-blade(-php)?$/', '/^page-template-views/'], '', $class);
    }, $classes);

    return array_filter($classes);
});

/**
 * Add "… Continued" to the excerpt
 */
add_filter('excerpt_more', function () {
    return ' &hellip; <a href="' . get_permalink() . '">' . __('Continued', 'muy-lindo') . '</a>';
});

/**
 * Template Hierarchy should search for .blade.php files
 */
collect([
    'index', '404', 'archive', 'author', 'category', 'tag', 'taxonomy', 'date', 'home',
    'frontpage', 'page', 'paged', 'search', 'single', 'singular', 'attachment', 'embed'
])->map(function ($type) {
    add_filter("{$type}_template_hierarchy", __NAMESPACE__.'\\filter_templates');
});

/**
 * Render page using Blade
 */
add_filter('template_include', function ($template) {
    collect(['get_header', 'wp_head'])->each(function ($tag) {
        ob_start();
        do_action($tag);
        $output = ob_get_clean();
        remove_all_actions($tag);
        add_action($tag, function () use ($output) {
            echo $output;
        });
    });
    $data = collect(get_body_class())->reduce(function ($data, $class) use ($template) {
        return apply_filters("sage/template/{$class}/data", $data, $template);
    }, []);
    if ($template) {
        echo template($template, $data);
        return get_stylesheet_directory().'/index.php';
    }
    return $template;
}, PHP_INT_MAX);

/**
 * Render comments.blade.php
 */
add_filter('comments_template', function ($comments_template) {
    $comments_template = str_replace(
        [get_stylesheet_directory(), get_template_directory()],
        '',
        $comments_template
    );

    $data = collect(get_body_class())->reduce(function ($data, $class) use ($comments_template) {
        return apply_filters("sage/template/{$class}/data", $data, $comments_template);
    }, []);

    $theme_template = locate_template(["views/{$comments_template}", $comments_template]);

    if ($theme_template) {
        echo template($theme_template, $data);
        return get_stylesheet_directory().'/index.php';
    }

    return $comments_template;
}, 100);


function cc_mime_types($mimes) {
    $mimes['svg'] = 'image/svg+xml';
    return $mimes;
}
if(function_exists('get_field') && get_field('allow_svg','option')) {
    add_filter('mime_types',  __NAMESPACE__.'\\cc_mime_types');
}

add_filter('wp_nav_menu_objects', function ($items, $args) {
    
    if(!function_exists('get_field')) return $items; 

    // loop
    foreach ($items as $item) {

        // vars
        $style = get_field('link_style', $item);
        $hide_menu_label = get_field('hide_menu_label', $item);
        $icon = get_field('menu_icon', $item);
        $font_weight = get_field('link_font_weight', $item);
        $rounded = get_field('rounded', $item);

        // append icon
        if($hide_menu_label) {
            if($icon) {
                $item->classes[] = 'with-icon';
                $item->title = '<img alt="'. esc_url($icon['title']) .'" src="'. esc_url($icon['url']) .'" />';
            } else {
                if ($style) {
                    $item->classes[] = $style;
                }
                if ($font_weight) {
                    $item->classes[] = $font_weight;
                }
                if ($rounded) {
                    $item->classes[] = $rounded;
                }
            }
        } else {
            if ($icon) {
                $item->classes[] = 'with-icon';
                $item->title .= '<img alt="' . esc_url($icon['title']) . '" src="' . esc_url($icon['url']) . '" />';
            } else {
                if ($style) {
                    $item->classes[] = $style;
                }
                if ($font_weight) {
                    $item->classes[] = $font_weight;
                }
                if ($rounded) {
                    $item->classes[] = $rounded;
                }
            }
        }
    }


    // return
    return $items;
}, 10, 2);

function custom_inner_blocks_allowed_blocks($allowed_blocks, $field, $block_id) {
    $allowed_blocks = array(
        'core/paragraph',
        'core/image',
        'core/gallery'
    );

    return $allowed_blocks;
}
add_filter('acf/allowed_block_types', 'custom_inner_blocks_allowed_blocks', 10, 3);

// Fix for align full block
add_filter('theme_file_path', function($path, $file) {
    if($file === 'theme.json') {
        return false;
    }
    return $path;
}, 0, 2);
