<?php

namespace App;

// Register custom blocks
if (function_exists('acf_register_block_type')) {
  add_action('init', function () {
    $product_plural_name = get_field('product_plural_name', 'options') ?: 'Products';
    $service_plural_name = get_field('service_plural_name', 'options') ?: 'services';

    acf_register_block_type(array(
      'name'              => 'slider',
      'title'             => __('Slider', 'muy-lindo'),
      'description'       => __('Slider of images', 'muy-lindo'),
      'render_callback'   => 'App\\muy_blocks_callback',
      'category'          => 'muy-blocks',
      'icon'              => 'leftright',
      'keywords'          => array('slider', 'image', 'custom'),
      'supports'          => array(
        'align' => array(
          'left',
          'right',
          'full',
          'wide'
        ),
      ),
    ));

    acf_register_block_type(array(
      'name'              => 'posts_list',
      'title'             => __('Posts List', 'muy-lindo'),
      'description'       => __('Select posts to show', 'muy-lindo'),
      'render_callback'   => 'App\\muy_blocks_callback',
      'category'          => 'muy-blocks',
      'icon'              => 'list-view',
      'keywords'          => array('posts', 'image', 'custom'),
      'supports'          => array(
        'align' => array(
          'left',
          'right',
          'full',
          'wide'
        ),
      ),
    ));

    acf_register_block_type(array(
      'name'              => 'animations',
      'title'             => __('Animations', 'muy-lindo'),
      'description'       => __('Animations block', 'muy-lindo'),
      'render_callback'   => 'App\\muy_blocks_callback',
      'category'          => 'muy-blocks',
      'icon'              => 'controls-forward',
      'keywords'          => array('animate', 'animations', 'custom'),
      'supports'          => array(
        'align' => array(
          'left',
          'right',
          'full',
          'wide'
        ),
        'mode' => false,
        '__experimental_jsx' => true,
      ),
    ));

    acf_register_block_type(array(
      'name'              => 'carousel',
      'title'             => __('Carousel', 'muy-lindo'),
      'description'       => __('Carousel', 'muy-lindo'),
      'render_callback'   => 'App\\muy_blocks_callback',
      'category'          => 'muy-blocks',
      'icon'              => 'editor-insertmore',
      'keywords'          => array('slider', 'carousel', 'custom'),
      'supports'          => array(
        'align' => array(
          'left',
          'right',
          'full',
          'wide'
        ),
        '__experimental_jsx' => true,
      ),
    ));

    acf_register_block_type(array(
      'name'              => 'overlay',
      'title'             => __('Overlay', 'muy-lindo'),
      'description'       => __('Overlay', 'muy-lindo'),
      'render_callback'   => 'App\\muy_blocks_callback',
      'category'          => 'muy-blocks',
      'icon'              => 'editor-insertmore',
      'keywords'          => array('overlay', 'custom'),
      'supports'          => array(
        'align' => array(
          'left',
          'right',
          'full',
          'wide'
        ),
        'mode'               => false,
        '__experimental_jsx' => true,
        'multiple'           => false
      ),
    ));

    acf_register_block_type(array(
      'name'              => 'slide',
      'title'             => __('slide', 'muy-lindo'),
      'description'       => __('slide', 'muy-lindo'),
      'render_callback'   => 'App\\muy_blocks_callback',
      'category'          => 'muy-blocks',
      'icon'              => 'editor-insertmore',
      'keywords'          => array('slide', 'custom'),
      'parent'            => array('acf/carousel'),
      'supports'          => array(
        'align' => array(
          'left',
          'right',
          'full',
          'wide'
        ),
        'mode' => false,
        '__experimental_jsx' => true,
      ),
    ));

    acf_register_block_type(array(
      'name'              => 'file',
      'title'             => __('File Custom', 'muy-lindo'),
      'description'       => __('File block custom', 'muy-lindo'),
      'render_callback'   => 'App\\muy_blocks_callback',
      'category'          => 'muy-blocks',
      'icon'              => 'media-document',
      'keywords'          => array('file', 'custom'),
      'supports'          => array(
        'align' => array(
          'left',
          'right',
          'full',
          'wide'
        ),
      ),
    ));

    if (MUY_ALLOW_PRODUCTS) {
      acf_register_block_type(array(
        'name'              => 'products_list',
        'title'             => sprintf(__('%s List', 'muy-lindo'), $product_plural_name),
        'description'       => sprintf(__('Select %s to show', 'muy-lindo'), $product_plural_name),
        'render_callback'   => 'App\\muy_blocks_callback',
        'category'          => 'muy-blocks',
        'icon'              => 'tag',
        'keywords'          => array($product_plural_name, 'image', 'custom'),
        'supports'          => array(
          'align' => array(
            'left',
            'right',
            'full',
            'wide'
          ),
        ),
      ));
    }
    if (MUY_ALLOW_SERVICES) {
      acf_register_block_type(array(
        'name'              => 'services_list',
        'title'             => sprintf(__('%s List', 'muy-lindo'), $service_plural_name),
        'description'       => sprintf(__('Select %s to show', 'muy-lindo'), $service_plural_name),
        'render_callback'   => 'App\\muy_blocks_callback',
        'category'          => 'muy-blocks',
        'icon'              => 'clipboard',
        'keywords'          => array($service_plural_name, 'image', 'custom'),
        'supports'          => array(
          'align' => array(
            'left',
            'right',
            'full',
            'wide'
          ),
        ),
      ));
    }

    acf_register_block_type(array(
      'name'              => 'accordion',
      'title'             => __('Accordion', 'muy-lindo'),
      'description'       => __('Accordion', 'muy-lindo'),
      'render_callback'   => 'App\\muy_blocks_callback',
      'category'          => 'muy-blocks',
      'icon'              => 'editor-insertmore',
      'keywords'          => array('slider', 'image', 'custom'),
      'supports'          => array(
        'align' => array(
          'left',
          'right',
          'full',
          'wide'
        ),
        'mode' => false,
        '__experimental_jsx' => true,
      ),
    ));

    acf_register_block_type(array(
      'name'              => 'map',
      'title'             => __('Map', 'muy-lindo'),
      'description'       => __('Group of Google Maps', 'muy-lindo'),
      'render_callback'   => 'App\\muy_blocks_callback',
      'category'          => 'muy-blocks',
      'icon'              => 'location-alt',
      'mode'              => 'false',
      'keywords'          => array('map', 'google', 'contact', 'location', 'geo'),
      'supports'          => array(
        'align' => array(
          'left',
          'right',
          'full',
          'wide'
        ),
      ),
    ));

    acf_register_block_type(array(
      'name'              => 'rounded-card',
      'title'             => __('Card with rounded borders', 'muy-lindo'),
      'description'       => __('This block shows a Card with rounded borders.', 'muy-lindo'),
      'render_callback'   => 'App\\muy_blocks_callback',
      'category'          => 'muy-blocks',
      'icon'              => 'clipboard',
      'mode'              => 'edit',
      'keywords'          => array('card', 'rounded', 'rounded card', 'custom'),
      'supports'          => array(
        'anchor' => true,
        'jsx' => true,
      ),
    ));

    acf_register_block_type(array(
      'name'              => 'team-list',
      'title'             => __('Team List', 'muy-lindo'),
      'description'       => __('Show the team', 'muy-lindo'),
      'render_callback'   => 'App\\muy_blocks_callback',
      'category'          => 'muy-blocks',
      'icon'              => 'list-view',
      'keywords'          => array('team', 'list', 'custom'),
      'mode'              => 'edit',
      'supports'          => array(
        'mode'  => false,
      ),
    ));

    acf_register_block_type(array(
      'name'              => 'card-slider',
      'title'             => __('Card Slider', 'muy-lindo'),
      'description'       => __('Slider of cards', 'muy-lindo'),
      'render_callback'   => 'App\\muy_blocks_callback',
      'category'          => 'muy-blocks',
      'icon'              => 'editor-insertmore',
      'keywords'          => array('slider', 'card', 'card-slider', 'list', 'custom'),
      'mode'              => 'edit',
      'supports'          => array(
        'mode'  => false,
      ),
    ));
  });
}

function muy_blocks_callback($block)
{
  $slug = str_replace('acf/', '', $block['name']);
  $block['slug'] = $slug;
  $block['classes'] = implode(' ', [$block['slug'], $block['className'], 'align' . $block['align']]);
  $template = null;
  $data = collect(get_body_class())->reduce(function ($data, $class) use ($template) {
    return apply_filters("sage/template/{$class}/data", $data, $template);
  }, []);

  $data['block'] = $block;
  echo \App\template("blocks/${slug}", $data);
}

//Create custom Gutenberg category
add_filter('block_categories', function ($categories, $post) {
  return array_merge(
    array(
      array(
        'slug' => 'muy-blocks',
        'title' => __('Muy Lindo Blocks', 'muy-lindo'),
      ),
    ),
    $categories
  );
}, 10, 2);

// add_filter( 'allowed_block_types', function ( $allowed_blocks, $post ) {  
//   $allowed_blocks = array(
// 		'core/image',
// 		'core/paragraph',
// 		'core/heading',
// 		'core/list'
// 	);

//   return $allowed_blocks;
// }, 10, 2);

