<?php

namespace App;

function get_pattern_html($filename)
{
  $file = "../app/gutenberg/patterns/{$filename}.php";
  $path = locate_template($file);
  $output = file_get_contents($path, true);

  return $output;
}

add_action('init', function () {
  if(function_exists('register_block_pattern_category')) {
    register_block_pattern_category(
      'muy-lindo',
      array('label' => __('Muy Lindo', 'thor'))
    );
  }

  if (function_exists('register_block_pattern')) {
    //CENTER
    register_block_pattern(
      'muy-lindo/center-1',
      array(
        'title'       => __('Center 1', 'thor'),
        'categories'  => ['header', 'muy-lindo'],
        'description' => __('', 'thor'),
        'content'     => get_pattern_html('center-1'),
      )
    );
    
    register_block_pattern(
      'muy-lindo/center-2',
      array(
        'title'       => __('Center 2', 'thor'),
        'categories'  => ['header', 'muy-lindo'],
        'description' => __('', 'thor'),
        'content'     => get_pattern_html('center-2'),
      )
    );
    
    register_block_pattern(
      'muy-lindo/center-3',
      array(
        'title'       => __('Center 3', 'thor'),
        'categories'  => ['header', 'muy-lindo'],
        'description' => __('', 'thor'),
        'content'     => get_pattern_html('center-3'),
      )
    );
    
    register_block_pattern(
      'muy-lindo/center-4',
      array(
        'title'       => __('Center 4', 'thor'),
        'categories'  => ['header', 'muy-lindo'],
        'description' => __('', 'thor'),
        'content'     => get_pattern_html('center-4'),
      )
    );

    //GRID
    register_block_pattern(
      'muy-lindo/grid-1',
      array(
        'title'       => __('Grid 1', 'thor'),
        'categories'  => ['columns', 'muy-lindo'],
        'description' => __('', 'thor'),
        'content'     => get_pattern_html('grid-1'),
      )
    );

    register_block_pattern(
      'muy-lindo/grid-2',
      array(
        'title'       => __('Grid 2', 'thor'),
        'categories'  => ['columns', 'muy-lindo'],
        'description' => __('', 'thor'),
        'content'     => get_pattern_html('grid-2'),
      )
    );

    register_block_pattern(
      'muy-lindo/grid-3',
      array(
        'title'       => __('Grid 3', 'thor'),
        'categories'  => ['columns', 'muy-lindo'],
        'description' => __('', 'thor'),
        'content'     => get_pattern_html('grid-3'),
      )
    );

    //TWO COLUMNS
    register_block_pattern(
      'muy-lindo/left-right-1',
      array(
        'title'       => __('Two columns 1', 'thor'),
        'categories'  => ['text', 'muy-lindo'],
        'description' => __('', 'thor'),
        'content'     => get_pattern_html('left-right-1'),
      )
    );

    register_block_pattern(
      'muy-lindo/left-right-2',
      array(
        'title'       => __('Two columns 2', 'thor'),
        'categories'  => ['text', 'muy-lindo'],
        'description' => __('', 'thor'),
        'content'     => get_pattern_html('left-right-2'),
      )
    );

    register_block_pattern(
      'muy-lindo/left-right-3',
      array(
        'title'       => __('Two columns 3', 'thor'),
        'categories'  => ['text', 'muy-lindo'],
        'description' => __('', 'thor'),
        'content'     => get_pattern_html('left-right-3'),
      )
    );

    register_block_pattern(
      'muy-lindo/left-right-4',
      array(
        'title'       => __('Two columns 4', 'thor'),
        'categories'  => ['text', 'muy-lindo'],
        'description' => __('', 'thor'),
        'content'     => get_pattern_html('left-right-4'),
      )
    );

    register_block_pattern(
      'muy-lindo/left-right-5',
      array(
        'title'       => __('Two columns 5', 'thor'),
        'categories'  => ['text', 'muy-lindo'],
        'description' => __('', 'thor'),
        'content'     => get_pattern_html('left-right-5'),
      )
    );
  }
});
