<?php

namespace App;

add_action('enqueue_block_editor_assets', function () {
  wp_enqueue_script('muy-gutenberg', asset_path('scripts/gutenberg.js'), array(), '1.0');

  wp_enqueue_script('muy-gutenberg-custom-styles', asset_path('scripts/gutenberg-custom-styles.js'), array('wp-blocks'), '1.0', true);
});

//custom styles
/**
 * Theme setup
 */

add_action('after_setup_theme', function () {
  add_theme_support('editor-styles');
  add_theme_support('align-wide');
  add_theme_support('responsive-embeds');
  add_theme_support('wp-block-styles');
  add_theme_support('custom-line-height');
  add_theme_support('custom-spacing');
  add_theme_support('custom-units');
  	
  // remove_theme_support( 'core-block-patterns' );

  add_editor_style(asset_path('styles/gutenberg.css'));

  // add_theme_support( 'disable-custom-colors' );
  // Next line replace color palette

  $colors = get_gutenberg_colors_matrix();
  $colors_array = [];

  foreach ($colors as $number => $item) {
    $color = get_theme_mod('muy_global_color_' . $number) ?: $item['default'];

    if ($color) {
      $colors_array[] = array(
        'name' => __('Color ' . $number, 'muy-lindo'),
        'slug' => 'color-' . $number,
        'color' => $color,
      );
    }
  }

  add_theme_support('editor-color-palette', $colors_array);

  add_theme_support('editor-font-sizes', array(
    array(
      'name' => __('Extra small', 'muy-lindo'),
      'size' => 12,
      'slug' => 'extra-small'
    ),
    array(
      'name' => __('Small', 'muy-lindo'),
      'size' => 14,
      'slug' => 'small'
    ),
    array(
      'name' => __('Normal', 'muy-lindo'),
      'size' => 16,
      'slug' => 'normal'
    ),
    array(
      'name' => __('Large', 'muy-lindo'),
      'size' => 18,
      'slug' => 'large'
    ),
    array(
      'name' => __('XL', 'muy-lindo'),
      'size' => 24,
      'slug' => 'xl'
    ),
    array(
      'name' => __('2XL', 'muy-lindo'),
      'size' => 32,
      'slug' => '2xl'
    ),
    array(
      'name' => __('3XL', 'muy-lindo'),
      'size' => 40,
      'slug' => '3xl'
    ),
    array(
      'name' => __('4XL', 'muy-lindo'),
      'size' => 54,
      'slug' => '4xl'
    ),
    array(
      'name' => __('5XL', 'muy-lindo'),
      'size' => 64,
      'slug' => '5xl'
    ),
    array(
      'name' => __('6XL', 'muy-lindo'),
      'size' => 72,
      'slug' => '6xl'
    )
  ));

});


add_action('acf/input/admin_footer', function () {


  $colors = get_gutenberg_colors_matrix();
  foreach ($colors as $number => $item) {
    if (!empty(get_theme_mod('muy_global_color_' . $number) ?: $item['default'])) {
      $color[] = get_theme_mod('muy_global_color_' . $number) ?: $item['default'];
    }
  }

    ?>
    <script type="text/javascript">
      (function($) {

        acf.add_filter('color_picker_args', function(args, $field) {
          // do something to args
          args.palettes = <?php echo json_encode($color) ?>

          // return
          return args;
        });
      })(jQuery);
    </script>
    <?php  
});

/**
 * Block template for posts
 * @see https://www.billerickson.net/gutenberg-block-templates/
 *
 */
// add_action( 'init', function() {
//   //Creo un template per un post
//   $post_type_object = get_post_type_object( 'post' );
//   $post_type_object->template = array(
//     array( 'core/paragraph', array(
//       'placeholder' => 'Inserisci qui il sottotiolo',
//     ) ),
//     array( 'core/image', array(
//       'align' => 'wide',
//     ) ),
//     array( 'core/freeform', array(
//       'placeholder' => 'Inserisci il contenuto'
//     )),
//   );
//   $post_type_object->template_lock = 'all';q
// });