<?php

/**
* Disable ACF UI in non-development environment
*/
defined('ACF_LITE') || define('ACF_LITE', defined('WP_ENV') && WP_ENV !== 'development');


/**
 * Google maps api key
 */
$google_maps_api_key = get_field('google_maps_api_key', 'option');
add_filter('acf/settings/google_api_key', function () use ($google_maps_api_key) {
  return $google_maps_api_key;
});

/**
 * Place ACF JSON in field-groups directory
 */
add_filter('acf/settings/save_json', function ($path) {
  $path = dirname(__FILE__) . '/field-groups';

  return $path;
}, 10);

add_filter('acf/settings/load_json', function ($paths) {
  unset($paths[0]);
  $paths[] = dirname(__FILE__) . '/field-groups';
  return $paths;
}, 10, 1);


// ---------------
// ADMIN PAGES
// ------------------------------------------------------

add_action( 'init', function () {
  if (
    !(function_exists('acf_add_options_page')
      && function_exists('acf_add_options_sub_page')
    )
  ) return false;
  
  $general_conf = acf_add_options_page(array(
    'page_title' 	=> 'Configurazioni generali',
    'menu_title' 	=> 'Configurazioni',
    'menu_slug' 	=> 'theme-general-conf',
    'capability' 	=> 'edit_others_pages',
    'redirect'    => true,
    'icon_url'    => 'dashicons-welcome-view-site'
  ));

  acf_add_options_sub_page(array(
    'page_title' 	=> 'Opzioni generali',
    'menu_title' 	=> 'Generali',
    'parent_slug' 	=> $general_conf['menu_slug'],
  ));
  acf_add_options_sub_page(array(
    'page_title' 	=> 'Opzioni avanzate',
    'capability'  => 'activate_plugins',
    'menu_title' 	=> 'Avanzate',
    'parent_slug' 	=> $general_conf['menu_slug'],
  ));

  // $social_page = acf_add_options_page(array(
  //   'page_title' 	=> 'Account social',
  //   'menu_title' 	=> 'Social',
  //   'menu_slug' 	=> 'theme-social-account',
  //   'capability' 	=> 'edit_others_pages',
  //   'redirect'    => true,
  //   'icon_url'    => 'dashicons-share'
  // ));
});
    