<?php
$capabilities = array(
  'edit_files' => true,
  'manage_options' => true,
  'moderate_comments' => true,
  'manage_categories' => true,
  'manage_links' => true,
  'upload_files' => true,
  'import' => true,
  'unfiltered_html' => true,
  'edit_posts' => true,
  'edit_others_posts' => true,
  'edit_published_posts' => true,
  'publish_posts' => true,
  'edit_pages' => true,
  'read' => true,
  'level_9' => true,
  'level_8' => true,
  'level_7' => true,
  'level_6' => true,
  'level_5' => true,
  'level_4' => true,
  'level_3' => true,
  'level_2' => true,
  'level_1' => true,
  'level_0' => true,
  'edit_others_pages' => true,
  'edit_published_pages' => true,
  'publish_pages' => true,
  'delete_pages' => true,
  'delete_others_pages' => true,
  'delete_published_pages' => true,
  'delete_posts' => true,
  'delete_others_posts' => true,
  'delete_published_posts' => true,
  'delete_private_posts' => true,
  'edit_private_posts' => true,
  'read_private_posts' => true,
  'delete_private_pages' => true,
  'edit_private_pages' => true,
  'read_private_pages' => true,
  'unfiltered_upload' => true,
  'edit_dashboard' => true,
  'edit_theme_options' => true,
  'export' => true,
  'manage_admin_columns' => true,
  'view_all_aryo_activity_log' => true,
  'copy_posts' => true,
  'manage_polls' => true,
  'manage_capabilities' => true,
  'wpseo_manage_options' => true,
  'gravityforms_view_entries' => true,
  'gravityforms_edit_forms' => true,
  'tablepress_list_tables' => true,
  'tablepress_add_tables' => true,
  'tablepress_edit_tables' => true,
  'tablepress_import_tables' => true,
  'tablepress_export_tables' => true,
  'tablepress_access_about_screen' => true,
  'tablepress_access_options_screen' => false,
  'manage_woocommerce' => true,
  'view_woocommerce_reports' => true,
  'edit_product' => true,
  'read_product' => true,
  'delete_product' => true,
  'edit_products' => true,
  'edit_others_products' => true,
  'publish_products' => true,
  'read_private_products' => true,
  'delete_products' => true,
  'delete_private_products' => true,
  'delete_published_products' => true,
  'delete_others_products' => true,
  'edit_private_products' => true,
  'edit_published_products' => true,
  'manage_product_terms' => true,
  'edit_product_terms' => true,
  'delete_product_terms' => true,
  'assign_product_terms' => true,
  'edit_shop_order' => true,
  'read_shop_order' => true,
  'delete_shop_order' => true,
  'edit_shop_orders' => true,
  'edit_others_shop_orders' => true,
  'publish_shop_orders' => true,
  'read_private_shop_orders' => true,
  'delete_shop_orders' => true,
  'delete_private_shop_orders' => true,
  'delete_published_shop_orders' => true,
  'delete_others_shop_orders' => true,
  'edit_private_shop_orders' => true,
  'edit_published_shop_orders' => true,
  'manage_shop_order_terms' => true,
  'edit_shop_order_terms' => true,
  'delete_shop_order_terms' => true,
  'assign_shop_order_terms' => true,
  'edit_shop_coupon' => true,
  'read_shop_coupon' => true,
  'delete_shop_coupon' => true,
  'edit_shop_coupons' => true,
  'edit_others_shop_coupons' => true,
  'publish_shop_coupons' => true,
  'read_private_shop_coupons' => true,
  'delete_shop_coupons' => true,
  'delete_private_shop_coupons' => true,
  'delete_published_shop_coupons' => true,
  'delete_others_shop_coupons' => true,
  'edit_private_shop_coupons' => true,
  'edit_published_shop_coupons' => true,
  'manage_shop_coupon_terms' => true,
  'edit_shop_coupon_terms' => true,
  'delete_shop_coupon_terms' => true,
  'assign_shop_coupon_terms' => true,
  'editor' => true,
  'install_plugins' => false,
  'activate_plugins' => false,
  'update_plugins' => false,
  'edit_plugins' => false,
  'delete_plugins' => false,
  'install_themes' => false,
  'update_themes' => false,
  'switch_themes' => false,
  'edit_themes' => false,
  'delete_themes' => false,
  'list_users' => false,
  'create_users' => false,
  'delete_users' => false,
  'promote_users' => false,
  'edit_users' => false,
  'remove_users' => false,
  'gravityforms_create_form' => false,
  'gravityforms_delete_forms' => false,
  'gravityforms_preview_forms' => false,
  'gravityforms_view_entry_note' => false,
  'gravityforms_edit_entries' => false,
  'gravityforms_edit_entry_note' => false,
  'gravityforms_delete_entries' => false,
  'gravityforms_export_entries' => false,
  'gravityforms_edit_settings' => false,
  'gravityforms_uninstall' => false,
  'gravityforms_view_updates' => false,
  'gravityforms_view_addons' => false,
  'view_yga_dash' => true,
  'manage_yga_settings' => false,
  'manage_yga_extensions' => false,
  'view_wf_widget' => false,
  'gravityforms_view_settings' => false,
  'gravityforms_mailchimp_uninstall' => false,
  'gravityforms_zapier_uninstall' => false,
);

add_action('init', function () use ($capabilities) {
  add_role(
    'site-manager',
    'Site Manager',
    $capabilities
  );

  $role = get_role('site-manager');


  foreach ($capabilities as $capability => $enable) {
    if ($enable && !$role->has_cap($capability)) {
      $role->add_cap($capability);
    } elseif (!$enable && $role->has_cap($capability)) {
      $role->remove_cap($capability);
    }
  }
});

add_action('admin_menu', function () {
  if (current_user_can('site-manager')) {
    //General setting
    remove_menu_page('options-general.php');

    //ACF
    remove_menu_page('edit.php?post_type=acf');
    remove_menu_page('edit.php?post_type=acf-field-group');
  }
}, 999);
