<?php
namespace App;

add_action('init', function () {
    if (MUY_ALLOW_PRODUCTS) {
        if (class_exists('ACF')) {
            acf_add_options_page(array(
                'page_title'     => 'Products Configurations',
                'menu_title'     => 'Configurations',
                'capability'     => 'edit_others_pages',
                'menu_slug'     => 'muy-products-config',
                'icon_url'    => 'dashicons-welcome-view-site',
                'parent_slug' => 'edit.php?post_type=product',
            ));

            muy_define_cpt('product', array('menu_icon' => 'dashicons-block-default'));
        }
    }

    if (MUY_ALLOW_SERVICES) {
        if (class_exists('ACF')) {
            acf_add_options_page(array(
                'page_title'     => 'Services Configurations',
                'menu_title'     => 'Configurations',
                'capability'     => 'edit_others_pages',
                'menu_slug'     => 'muy-services-config',
                'icon_url'    => 'dashicons-welcome-view-site',
                'parent_slug' => 'edit.php?post_type=service',
            ));

            muy_define_cpt('service', array('menu_icon' => 'dashicons-clipboard'));
        }
    }
});


function muy_define_cpt ($slug = null, $params) {
    if (!function_exists('get_field')) return false;

    $label_placeholder = ucfirst($slug);

    $plural_name = get_field($slug.'_plural_name', 'options') ?: $label_placeholder.'s';
    $singular_name = get_field($slug.'_singular_name', 'options') ?: $label_placeholder;
    $permalink_base = get_field($slug.'_permalink_base', 'options') ?: $slug;


    $custom_taxonomy = get_field($slug.'_custom_taxonomy', 'options');
    $taxonomy_slug = 'category-'.$slug;


    // Register Custom Post Type
    $labels = array(
        'name'                  => _x($plural_name, 'muy-lindo'),
        'singular_name'         => _x($singular_name, 'muy-lindo'),
        'menu_name'             => _x($plural_name, 'muy-lindo'),
        'name_admin_bar'        => _x($plural_name, 'muy-lindo'),
        'archives'              => __('Items Archives', 'muy-lindo'),
        'attributes'            => __('Items Attributes', 'muy-lindo'),
        'parent_item_colon'     => __('Parent Item:', 'muy-lindo'),
        'all_items'             => __('All Items', 'muy-lindo'),
        'add_new_item'          => __('Add New Item', 'muy-lindo'),
        'add_new'               => __('Add New', 'muy-lindo'),
        'new_item'              => __('New Item', 'muy-lindo'),
        'edit_item'             => __('Edit Item', 'muy-lindo'),
        'update_item'           => __('Update Item', 'muy-lindo'),
        'view_item'             => __('View Item', 'muy-lindo'),
        'view_items'            => __('View Items', 'muy-lindo'),
        'search_items'          => __('Search Item', 'muy-lindo'),
        'not_found'             => __('Not found', 'muy-lindo'),
        'not_found_in_trash'    => __('Not found in Trash', 'muy-lindo'),
        'featured_image'        => __('Featured Image', 'muy-lindo'),
        'set_featured_image'    => __('Set featured image', 'muy-lindo'),
        'remove_featured_image' => __('Remove featured image', 'muy-lindo'),
        'use_featured_image'    => __('Use as featured image', 'muy-lindo'),
        'insert_into_item'      => __('Insert into item', 'muy-lindo'),
        'uploaded_to_this_item' => __('Uploaded to this item', 'muy-lindo'),
        'items_list'            => __('Items list', 'muy-lindo'),
        'items_list_navigation' => __('Items list navigation', 'muy-lindo'),
        'filter_items_list'     => __('Filter Items list', 'muy-lindo'),
    );

    $rewrite = array(
        'slug'                  => $permalink_base,
        'with_front'            => true,
        'pages'                 => true,
        'feeds'                 => true,
    );

    $args = array(
        'label'                 => __($singular_name, 'muy-lindo'),
        'description'           => __('Your products', 'muy-lindo'),
        'labels'                => $labels,
        'supports'              => array('title', 'editor', 'thumbnail', 'revisions'),
        'taxonomies'            => array($taxonomy_slug),
        'hierarchical'          => true,
        'public'                => true,
        'show_ui'               => true,
        'show_in_menu'          => true,
        'menu_position'         => 5,
        'menu_icon'             => $params['menu_icon'],
        'show_in_admin_bar'     => true,
        'show_in_nav_menus'     => true,
        'can_export'            => true,
        'has_archive'           => true,
        'exclude_from_search'   => false,
        'publicly_queryable'    => true,
        'rewrite'               => $rewrite,
        'show_in_rest'          => true,
        'capability_type'       => 'post',
    );
    register_post_type($slug, $args);

    // register taxonomy

    $taxonomy_labels = array(
        'name'                       => _x('Category ' . $plural_name, 'muy-lindo'),
        'singular_name'              => _x('Category ' . $singular_name, 'muy-lindo'),
        'menu_name'                  => __('Category ' . $singular_name, 'muy-lindo'),
        'all_items'                  => __('All Items', 'muy-lindo'),
        'parent_item'                => __('Parent Item', 'muy-lindo'),
        'parent_item_colon'          => __('Parent Item:', 'muy-lindo'),
        'new_item_name'              => __('New Item Name', 'muy-lindo'),
        'add_new_item'               => __('Add New Item', 'muy-lindo'),
        'edit_item'                  => __('Edit Item', 'muy-lindo'),
        'update_item'                => __('Update Item', 'muy-lindo'),
        'view_item'                  => __('View Item', 'muy-lindo'),
        'separate_items_with_commas' => __('Separate items with commas', 'muy-lindo'),
        'add_or_remove_items'        => __('Add or remove items', 'muy-lindo'),
        'choose_from_most_used'      => __('Choose from the most used', 'muy-lindo'),
        'popular_items'              => __('Popular Items', 'muy-lindo'),
        'search_items'               => __('Search Items', 'muy-lindo'),
        'not_found'                  => __('Not Found', 'muy-lindo'),
        'no_terms'                   => __('No items', 'muy-lindo'),
        'items_list'                 => __('Items list', 'muy-lindo'),
        'items_list_navigation'      => __('Items list navigation', 'muy-lindo'),
    );
    $taxonomy_rewrite = array(
        'slug'                       => __('category-', 'muy-lindo') . $permalink_base,
        'with_front'                 => true,
        'hierarchical'               => false,
    );
    $taxonomy_args = array(
        'labels'                     => $taxonomy_labels,
        'hierarchical'               => true,
        'public'                     => true,
        'show_ui'                    => true,
        'show_admin_column'          => true,
        'show_in_nav_menus'          => true,
        'show_tagcloud'              => true,
        'show_in_rest'               => true,
        'rewrite'                    => $taxonomy_rewrite,
    );
    register_taxonomy($taxonomy_slug, array($slug), $taxonomy_args);
};