import Swiper, { Autoplay, Navigation, Pagination } from 'swiper';

export default () => {
  const cardSlider = $('.muy-card-slider');

  cardSlider.each(function () {
    const slider = $(this).find('.swiper');
    const prevEl = $(this).find('.custom-button-prev').get(0);
    const nextEl = $(this).find('.custom-button-next').get(0);

    new Swiper(slider.get(0), {
      modules: [Autoplay, Navigation, Pagination],
      slidesPerView: 1,
      spaceBetween: 20,
      watchOverflow: true,
      navigation: {
        nextEl,
        prevEl,
      },
      breakpoints: {
        640: {
          slidesPerView: 2,
        },
        1024: {
          slidesPerView: 3,
        },
      },
    });
  });
};