export default () => {
  jQuery(document).ready(function ($) {
    const overlays = $('.muy-overlay');

    overlays.each(function () {
      const overlay = $(this);

      $('html').addClass('locked');
      const enableAutoAnimation = overlay.data('overlay-animation');
      const animationTimeout = overlay.data('overlay-timeout') || 5000;
      const closingTriggerClassRaw = overlay.data('closing-trigger') || false;
      const allowScrollClosing = overlay.data('allow-scroll-closing') || false;
      const outAnimationClass = overlay.data('out-animation-class') || 'fade-out';

      const closingTriggerClass = '.' + closingTriggerClassRaw;
      const closingTriggerElement = $(closingTriggerClass);

      if (enableAutoAnimation) {
        $('html').addClass('locked');
        setTimeout(function () {
          overlay.trigger('closeOverlay');
        }, animationTimeout);
      }

      if (closingTriggerClassRaw && closingTriggerElement.length) {
        closingTriggerElement.on('click', function () {
          overlay.trigger('closeOverlay');
        });
      }

      if (allowScrollClosing) {
        $(window).on('mousewheel DOMMouseScroll touchmove', function (event) {
          if (
            (event.type === 'mousewheel' || event.type === 'DOMMouseScroll' || event.type === 'touchmove') &&
            !overlay.hasClass('fade-out') &&
            !overlay.hasClass('no-fade')
          ) {
            overlay.addClass(outAnimationClass);
            setTimeout(() => {
              $('html').removeClass('locked');
            }, 600);
            setTimeout(() => {
              overlay.hide(0);
            }, 3000);
          }
        });
      }


      overlay.on('closeOverlay', function () {
        overlay.addClass(outAnimationClass);
        $('html').removeClass('locked');
        setTimeout(() => {
          overlay.hide(0);
        }, 3000);
      });
    });
  });
}