// import external dependencies
import 'jquery';
// import './vueApp';
import 'jquery-match-height'
// import 'slick-carousel';
import LazyLoad from 'vanilla-lazyload'
import Glightbox from 'glightbox'
import AOS from 'aos';
import './layout/overlay-menu';
import './layout/search';

// import maps from './util/maps';
import blocks from './blocks/gutenberg-blocks';

// Import everything from autoload
import './autoload/**/*'

// import local dependencies
blocks()

Glightbox({
  selector: 'wp-block-gallery figure a img',
})

new LazyLoad({
  elements_selector: '.lazy',
})

export default (() => {
  $(window).scroll(function () {
    if ($(this).scrollTop() >= 50) {
      $('body').addClass('scrolled');
    } else {
      $('body').removeClass('scrolled');
    }
  });

  $(document).ready(function () {
    var previousScroll = 0;
    var navbar = $('.main-header.scroll-hide');
    var navbarHeight = navbar.outerHeight();
    var scrollThreshold = 1;
    navbar.addClass('visible');

    $(window).scroll(function () {
      var currentScroll = $(this).scrollTop();

      if (currentScroll > previousScroll && currentScroll > navbarHeight) {
        if (currentScroll - previousScroll > scrollThreshold) {
          navbar.removeClass('visible');
        }
      } else if (previousScroll - currentScroll > scrollThreshold) {
        navbar.addClass('visible');
      }

      previousScroll = currentScroll;
    });
  });
})();