@extends('layouts.app')

@php
  $muy_products_teaser_per_row = get_theme_mod('muy_products_teaser_per_row');

  switch ($muy_products_teaser_per_row) {
    case '1':
      $column_class = "w-full px-4 teaser-single-column";
    break;

    case '2':
      $column_class = "w-full md__w-1/2 px-4 teaser-multi-column";
    break;

    case '4':
      $column_class = "w-full md__w-1/2 lg__w-1/4 px-4 teaser-multi-column";
    break;

    default:
      $column_class = "w-full md__w-1/2 lg__w-1/3 px-4 teaser-multi-column";
    break;
  }
@endphp

@section('content')
  @include('partials.page-header')

  <div class="container">
    @if (!have_posts())
      <div class="no-results-found">
        <div class="alert alert-warning">
          <h2>{{ __('Sorry, no results were found.', 'muy-lindo') }}</h2>
        </div>
        <div>
          <a href="{!! get_home_url(); !!}" class="btn">{!! __('Back to home','muy-lindo') !!}</a>
        <div>
      </div>
    @else
      <div class="-mx-4 row">
        @while (have_posts())
          @php the_post() @endphp
          <div class="{{ $column_class }}">
            @include('partials.teaser-'.get_post_type())
          </div>
        @endwhile
      </div><!--row-->
    @endif

    {!! get_the_posts_navigation() !!}

    @php
      wp_reset_query();
    @endphp

  </div><!--container-->
@endsection
