@php
  /**
   * Testimonial Block Template.
   *
   * @param   array $block The block settings and attributes.
   * @param   string $content The block inner HTML (empty).
   * @param   bool $is_preview True during AJAX preview.
   * @param   (int|string) $post_id The post ID this block is saved to.
   */

  // Create id attribute allowing for custom "anchor" value.
  $id = 'muy-accordion-' . $block['id'];
  if( !empty($block['anchor']) ) {
    $id = $block['anchor'];
  }

  // Create class attribute allowing for custom "className" and "align" values.
  $className = 'muy-'.$block['slug'];

  if( !empty($block['className']) ) {
    $className .= ' ' . $block['className'];
  }
  if( !empty($block['align']) ) {
    $className .= ' align' . $block['align'];
  }

  $icon = get_field('accordion_icon');
  $label = get_field('accordion_label');
  $accordion_sync = get_field('accordion_sync');
  $accordion_label_color = get_field('accordion_title_color');
  $accordion_separator_color = get_field('accordion_separator_color');
  $accordion_background_color = get_field('accordion_background_color');
  $accordion_label_font_weight = get_field('accordion_label_font_weight');
  $accordion_label_font_size = get_field('accordion_label_font_size');
  $accordion_label_arrow_color = get_field('accordion_label_arrow_color');
  $accordion_height = get_field('accordion_height') ? : '';
  
@endphp

<div id="{!! esc_attr($id) !!}" class="{!! esc_attr($className); !!}" data-accordion-group="{!! $accordion_sync !!}">
  <div class="accordion-block-inner">
    <div
     class="accordion-header {!! $accordion_height !!} @if(!$accordion_background_color) no-space @endif"
     style="background:{!! $accordion_background_color !!}; border-color:{!! $accordion_separator_color !!};">

      <h5 style="color: {!! $accordion_label_color !!}"
          class="accordion-title {!! $accordion_label_font_weight !!} {!! $accordion_label_font_size !!}">
        @if($icon['url']) <img class="accordion-image" src=" {!! $icon['url'] !!} " /> @endif
        @if($label) {!! $label !!} @endif
      </h5>
      <div class="accordion-arrow">
        @if($accordion_label_arrow_color)
          <style>
            #{!! esc_attr($id) !!} svg * {
              fill: {!! $accordion_label_arrow_color !!};
            }
          </style>
        @endif 
        @svg('images/arrow-down.svg')
      </div>
    </div>


    <div class="accordion-content">
      <InnerBlocks />
    </div>

  </div>
</div>