@php
  /**
   * Testimonial Block Template.
   *
   * @param   array $block The block settings and attributes.
   * @param   string $content The block inner HTML (empty).
   * @param   bool $is_preview True during AJAX preview.
   * @param   (int|string) $post_id The post ID this block is saved to.
   */

  // Create id attribute allowing for custom "anchor" value.
  $id = 'muy-animations-' . $block['id'];
  if( !empty($block['anchor']) ) {
    $id = $block['anchor'];
  }

  // Create class attribute allowing for custom "className" and "align" values.
  $className = 'muy-'.$block['slug'];

  if( !empty($block['className']) ) {
    $className .= ' ' . $block['className'];
  }
  if( !empty($block['align']) ) {
    $className .= ' align' . $block['align'];
  }

  $animation_type = get_field('animation_type') ? get_field('animation_type') : 'fade';
  $once = get_field('once');
  $offset = get_field('offset') ?: 0;
  $easing = get_field('easing');
  $mirror = get_field('mirror');
  $anchor = get_field('anchor');
  $delay = get_field('delay');
  $duration = get_field('duration');
@endphp

<div
  id="{!! esc_attr($id) !!}"
  class="{!! esc_attr($className); !!}"
>
  <div
    data-aos="{!! $animation_type !!}"
    data-aos-once="{!! $once !!}"
    data-aos-offset="{!! $offset !!}"
    data-aos-easing="{!! $easing !!}"
    data-aos-mirror="{!! $mirror !!}"
    data-aos-anchor-placement="{!! $anchor !!}"
    data-aos-delay="{!! $delay !!}"
    data-aos-duration="{!! $duration !!}"
  >
    <InnerBlocks/>
  </div>
</div>