@php
  /**
   * Card Slider Block Template.
   *
   * @param   array $block The block settings and attributes.
   * @param   string $content The block inner HTML (empty).
   * @param   bool $is_preview True during AJAX preview.
   * @param   (int|string) $post_id The post ID this block is saved to.
   */

  // Create id attribute allowing for custom "anchor" value.
  $id = 'muy-' . $block['id'];
  if( !empty($block['anchor']) ) {
    $id = $block['anchor'];
  }

  // Create class attribute allowing for custom "className" and "align" values.
  $className = 'muy-'.$block['slug'];
  if( !empty($block['className']) ) {
    $className .= ' ' . $block['className'];
  }
  if( !empty($block['align']) ) {
    $className .= ' align' . $block['align'];
  }

  $cards = get_field('cards');
@endphp

<div id="{{ esc_attr($id) }}" class="{{ esc_attr($className) }}">
  @if($cards)
    <div class="card-slider-inner">
      <div class="swiper">
        <div class="swiper-wrapper">
          @foreach ($cards as $card)
            @php
                $icon = $card['icon'];
                $title = $card['title'];
                $text = $card['text'];
            @endphp
            <div class="swiper-slide">
              <div class="card-inner">
                <figure class="card-icon">
                  <img 
                    class="lazy"
                    src="{!! $icon['sizes']['medium'] !!}"
                    alt="{!! $icon['alt'] !!}"
                  />
                </figure>
                <div class="card-details">
                  @if($title)
                    <h3>
                      {!! $title !!}
                    </h3>
                  @endif
                  @if($text)
                    <div class="card-text">
                      {!! $text !!}
                    </div>
                  @endif
                </div>
              </div>
            </div>
          @endforeach
        </div>

        <div class="arrows-wrapper">
          <div class="custom-button-prev">
            <img src="@asset('images/circle-arrow-prev.svg')" alt="{{ __('circle-arrow-left', 'muy') }}">
          </div>
          <div class="custom-button-next">
            <img src="@asset('images/circle-arrow-next.svg')" alt="{{ __('circle-arrow-right', 'muy') }}">
          </div>
        </div>
      </div>
    </div>
  @endif
</div>