@php
  /*
  * Nei template dei blocchi creati con ACF non sarà possibile usare blade
  * perchè non viene interpretato nella preview in admin
  */

  // Create id attribute allowing for custom "anchor" value.
  $id = 'muy-carousel-' . $block['id'];
  if( !empty($block['anchor']) ) {
    $id = $block['anchor'];
  }

  // Create class attribute allowing for custom "className" and "align" values.
  $className = 'muy-'.$block['slug'];
  if( !empty($block['className']) ) {
    $className .= ' ' . $block['className'];
  }
  if( !empty($block['align']) ) {
    $className .= ' align' . $block['align'];
  }

  $default_slides = array(
    array(
      'text'  => __('Insert first slide', 'muy-lindo'),
    ),
  );

  // Load values and assign defaults.
  $slides = get_field('slides') ?: $default_slides;

  $dots = get_field('dots') ?: false;
  $next_arrow = get_field('next_arrow');
  $pause_on_hover = get_field('pause_on_hover');
  $before_arrow = get_field('before_arrow');
  $autoplay_speed = get_field('autoplay_speed');
  $max_width_content = get_field('max_width_content');
  $infinite = get_field('infinite') ?: false;
  $dots_color = get_field('dots_color');
  $dots_position = (int) get_field('dots_position');
  $autoplay = get_field('autoplay') ?: false;
  //slick slide crashes with infinite on false and slide to show on 0
  $slides_to_show = (int) get_field('slides_to_show');
  $arrows = get_field('arrows') ?: false;
  $slider_height = get_field('slider_height') ?: false;
  $slide_padding = get_field('slide_padding') ?: 20;
  $enable_border_radius_slide = get_field('enable_border_radius_slide');
  $cta = get_field('cta');
  $cta_with_download = get_field('cta_with_download');
  $cta_file = get_field('cta_file');
  $cta_file_title = get_field('cta_file_title');
  $cta_background_color = get_field('cta_background_color');
  $cta_text_color = get_field('cta_text_color');
  $border_radius_value = get_field('border_radius_value') ?: 12;
  $arrows_position_get = get_field('arrows_position');
  $arrows_position_mobile_get = get_field('arrows_position_mobile');
  $arrows_position = "";
  $arrows_position_mobile = "";

  switch ($slides_to_show) {
    case 4:
      $slides_to_show_screen_lg = 3;
      $slides_to_show_screen_md = 2;
      $slides_to_show_screen_sm = 1;
      break;
    case 3:
      $slides_to_show_screen_lg = 3;
      $slides_to_show_screen_md = 2;
      $slides_to_show_screen_sm = 1;
      break;
    case 2:
      $slides_to_show_screen_lg = 2;
      $slides_to_show_screen_md = 1;
      $slides_to_show_screen_sm = 1;
      break;
    default:
      $slides_to_show_screen_lg = 1;
      $slides_to_show_screen_md = 1;
      $slides_to_show_screen_sm = 1;
    break;
  }

  switch ($max_width_content) {
    case 380:
      $max_width_content_xs = 'max_width_content_xs';
      break;
    case 500:
      $max_width_content_sm = 'max_width_content_sm';
    case 650:
      $max_width_content_md = 'max_width_content_md';
      break;
    case 768:
      $max_width_content_lg = 'max_width_content_lg';
      break;
    case 1024:
      $max_width_content_xl = 'max_width_content_xl';
      break;
    case 1280:
      $max_width_content_2xl = 'max_width_content_2xl';
      break;
    default:
      $max_width_content_default = '';
    break;
  }

  switch ($arrows_position_get) {
    case 'top_left':
      $arrows_position = 'top-left';
      break;
    case 'top_right':
      $arrows_position = 'top-right';
      break;
    case 'bottom_left':
      $arrows_position = 'bottom-left';
      break;
    case 'bottom_right':
      $arrows_position = 'bottom-right';
      break;
    case 'bottom_center':
      $arrows_position = 'bottom-center';
      break;
  }

  switch ($arrows_position_mobile_get) {
    case 'top_left':
      $arrows_position_mobile = 'top-left-mobile';
      break;
    case 'top_right':
      $arrows_position_mobile = 'top-right-mobile';
      break;
    case 'bottom_left':
      $arrows_position_mobile = 'bottom-left-mobile';
      break;
    case 'bottom_right':
      $arrows_position_mobile = 'bottom-right-mobile';
      break;
    case 'bottom_center':
      $arrows_position_mobile = 'bottom-center-mobile';
      break;
  }

  $slick_options = array(
    'dots' => $dots,
    'infinite' => $infinite,
    'autoplay' => $autoplay,
    'autoplaySpeed'=> $autoplay_speed,
    'arrows' => $arrows,
    'pauseOnHover' => $pause_on_hover,
    'slidesToShow' => $slides_to_show,
    'prevArrow' => ".before-arrow",
    'nextArrow' => ".next-arrow",
    'responsive' => [
      array(
      'breakpoint' => 1024,
      'settings' => array(
        'slidesToShow' => $slides_to_show_screen_lg,
        'arrows' => false, 
        ),
      ),
      array(
      'breakpoint' => 870,
      'settings' => array(
        'slidesToShow' => $slides_to_show_screen_md,
        'arrows' => false, 
        ),
      ),
      array(
      'breakpoint' => 640,
      'settings' => array(
        'slidesToShow' => $slides_to_show_screen_sm,
        'arrows' => false,
        ),
      ),
    ],
  );

  $allowed_blocks = array( 'slide' );
@endphp

<div id="{{ esc_attr($id) }}" class="{{ esc_attr($className) }} muy-slider">
  @if($arrows)
    <div class="buttons-wrapper {!! $arrows_position !!} {!! $arrows_position_mobile !!}">
      <div class="buttons">
        <button
          type="button"
          @if ($before_arrow)  
          style="background-image: url('{!! $before_arrow['url'] !!}')"
          @endif
          class="{{ !$before_arrow ?: 'image-arrow' }} slick-arrow before-arrow slick-prev"
        >
        </button>
        <button
          type="button"
          @if ($next_arrow)  
          style="background-image: url('{!! $next_arrow['url'] !!}')"
          @endif 
          class="{{ !$next_arrow ?: 'image-arrow' }} slick-arrow next-arrow slick-next"
        >
        </button>
      </div>

      @if ($cta_with_download)
        <a href="{!! $cta_file['url'] !!}" download class="cta-file">
          {!! $cta_file_title !!}
        </a>
      @else
        <a href="{!! $cta['url'] !!}" target="{!! $cta['target'] !!}" class="cta">{!! $cta['title'] !!}</a>
      @endif
    </div>
  @endif
  <div class="slider @if($slider_height) {!! $slider_height !!} @endif @if($enable_border_radius_slide) slide-rounded @endif" data-slick="{!! esc_attr(json_encode($slick_options)) !!}">
    <InnerBlocks
        allowedBlocks={!! esc_attr( wp_json_encode( $allowed_blocks ) ) !!}
    />
  </div>

  <style>
    .slick-slide {
      margin: 0 {!! $slide_padding !!}px;
    }

    .slide-rounded .slide {
      overflow: hidden;
      border-radius: {!! $border_radius_value !!}px
    }

    .cta-file,
    .cta {
      display: flex;
      justify-content: center;
      align-items: center;
      height: 54px;
      padding: 18px 24px;
      border-radius: 50px;
      font-size: 1rem;
      letter-spacing: 0.1em;
      background-color: {!! $cta_background_color !!};
      color: {!! $cta_text_color !!};
    }

    #{{ esc_attr($id) }}.muy-slider .slider .slick-dots li.slick-active button::before {
      background-color: {!! $dots_color !!};
    }

    #{{ esc_attr($id) }}.muy-slider .slider .slick-dots li button::before {
      border-color: {!! $dots_color !!};
    }

    #{{ esc_attr($id) }} .slick-dots {
      position: relative;
      bottom: {!! $dots_position !!}px;
    }
  </style>
</div>