@php
  /**
   * Testimonial Block Template.
   *
   * @param   array $block The block settings and attributes.
   * @param   string $content The block inner HTML (empty).
   * @param   bool $is_preview True during AJAX preview.
   * @param   (int|string) $post_id The post ID this block is saved to.
   */

  // Create id attribute allowing for custom "anchor" value.
  $id = 'file-custom' . $block['id'];
  if( !empty($block['anchor']) ) {
    $id = $block['anchor'];
  }

  // Create class attribute allowing for custom "className" and "align" values.
  $className = 'muy-'.$block['slug'];

  if( !empty($block['className']) ) {
    $className .= ' ' . $block['className'];
  }
  if( !empty($block['align']) ) {
    $className .= ' align' . $block['align'];
  }

  $file = get_field('file');
  $text = get_field('text');
  $show_download_button = get_field('show_download_button');
  $blank = get_field('blank');
  $divider_top = get_field('divider_top');
  $divider_bottom = get_field('divider_bottom');
  $download_button_color = get_field('download_button_color');
  $download_button_text_color = get_field('download_button_text_color');
@endphp

<style>
  .muy-file .wp-block-file__button.wp-element-button {
    background-color: {!! $download_button_color !!};
    color: {!! $download_button_text_color !!};
  }

  .muy-file.no-divider-top {
    border-top: none;
  }
</style>

<div id="{!! esc_attr($id) !!}" class="{!! esc_attr($className); !!} wp-block-file
  @if ($divider_top)
    no-divider-top
  @endif
  @if ($divider_bottom)
    divider-bottom
  @endif">
  @if ($file['url'] && $text)
    <a href="{!! $file['url'] !!}"
    @if ($blank)
      target="blank"
    @endif
    >
      {!! $text !!}
    </a>
  @endif
  @if ($file['url'] && $show_download_button)
    <a href="{!! $file['url'] !!}" class="wp-block-file__button wp-element-button" download>Download</a>
  @endif
</div>