@php
  /*
  * Nei template dei blocchi creati con ACF non sarà possibile usare blade
  * perchè non viene interpretato nella preview in admin
  */

  // Create id attribute allowing for custom "anchor" value.
  $id = 'muy-map-' . $block['id'];
  if( !empty($block['anchor']) ) {
    $id = $block['anchor'];
  }

  // Create class attribute allowing for custom "className" and "align" values.
  $className = 'muy-'.$block['slug'];
  if( !empty($block['className']) ) {
    $className .= ' ' . $block['className'];
  }
  if( !empty($block['align']) ) {
    $className .= ' align' . $block['align'];
  }

  $markers = get_field('markers');
  $maps_height = get_field('maps_height');
  $zoom_controls = get_field('zoom_controls');
  $fullscreen_controls = get_field('fullscreen_controls');
  $streetview = get_field('streetview');
  $type_map_controls = get_field('type_map_controls');
  $cluster_icon = get_field('cluster_icon');
  $maps_style = get_field('maps_style');
  $maps_style_decode = json_decode($maps_style);
  $maps_style_encode = json_encode($maps_style_decode);
@endphp

@if($markers)
  <div id="{{ esc_attr($id) }}" class="{{ esc_attr($className) }}" itemscope itemtype="http://schema.org/Place">
    <div class="admin-preview">
      {{ __('Blocco Mappa', 'muy-lindo') }}
      @svg('images/maps-icon.svg')
    </div>
    <div class="map" id="map-{!! $id !!}" itemprop="geo" itemscope itemtype="http://schema.org/GeoCoordinates" style="@if($maps_height['height'] && $maps_height['unit'])height:{!! $maps_height['height'] !!}{!! $maps_height['unit'] !!}; @endif"
    data-style='{!! $maps_style_encode !!}'
    data-zoom="{!! $zoom_controls !!}"
    data-fullscreen="{!! $fullscreen_controls !!}"
    data-streetview="{!! $streetview !!}"
    data-type="{!! $type_map_controls !!}"
    data-cluster-icon="{!! $cluster_icon['url'] !!}"
    >
      @foreach($markers as $mark)
      @php
        $icon = $mark['icon'];
        $address = $mark['address'];
        $geo_position = $mark['geo_position'];
      @endphp
      <div class="marker"
        itemprop="latitude" content="{!! $geo_position['lat'] !!}"
        itemprop="longitude" content="{!! $geo_position['lng'] !!}"
        data-icon="{!! $icon['url'] !!}"
        data-lat="{!! $geo_position['lat'] !!}"
        data-lng="{!! $geo_position['lng'] !!}">
        @if($address)
          <div class="info-window">
            {!! $address !!}
          </div> 
        @endif
      </div><!--marker-->
      @endforeach
    </div>
  </div>
@endif