@php
  /**
   * Testimonial Block Template.
   *
   * @param   array $block The block settings and attributes.
   * @param   string $content The block inner HTML (empty).
   * @param   bool $is_preview True during AJAX preview.
   * @param   (int|string) $post_id The post ID this block is saved to.
   */

  // Create id attribute allowing for custom "anchor" value.
  $id = 'muy-overlay-' . $block['id'];
  if( !empty($block['anchor']) ) {
    $id = $block['anchor'];
  }

  // Create class attribute allowing for custom "className" and "align" values.
  $className = 'muy-'.$block['slug'];

  if( !empty($block['className']) ) {
    $className .= ' ' . $block['className'];
  }
  if( !empty($block['align']) ) {
    $className .= ' align' . $block['align'];
  }

  $animation_timeout = get_field('animation_timeout') ?: 1000;
  $enable_auto_animation = get_field('enable_auto_animation');
  $enable_scroll_closing = get_field('enable_scroll_closing');
  $close_overlay_button_class = get_field('close_overlay_button_class');
  $animations_closing_type = get_field('animations_closing_type');
@endphp

<div
  id="{!! esc_attr($id) !!}"
  class="{!! esc_attr($className); !!}"
  data-overlay-timeout="{!! $animation_timeout !!}"
  data-overlay-animation="{!! $enable_auto_animation !!}"
  data-out-animation-class="{!! $animations_closing_type !!}"
  data-allow-scroll-closing="{!! $enable_scroll_closing !!}"
  data-closing-trigger="{!! $close_overlay_button_class !!}"
>
  <InnerBlocks/>
</div>