@php
  /**
   * Testimonial Block Template.
   *
   * @param   array $block The block settings and attributes.
   * @param   string $content The block inner HTML (empty).
   * @param   bool $is_preview True during AJAX preview.
   * @param   (int|string) $post_id The post ID this block is saved to.
   */

  $id = 'muy-posts-list' . $block['id'];
  if( !empty($block['anchor']) ) {
    $id = $block['anchor'];
  }
  $className = 'muy-'.$block['slug'];
  if( !empty($block['className']) ) {
    $className .= ' container ' . $block['className'];
  }
  if( !empty($block['align']) ) {
    $className .= ' align' . $block['align'];
  }


  $posts_teaser_image_height = get_field('posts_teaser_image_height');
  $posts_per_row = get_field('posts_per_row');
  $title_color = get_field('title_color');
  $excerpt_color = get_field('excerpt_color');
  $cta_color = get_field('cta_color');
  $posts = '';
  $selected = get_field('selected_posts');
  $category = get_field('print_category');
  $select_type = get_field('select_type');
  $n = get_field('posts_number');
 
  switch ($posts_per_row) {
    case '1':
      $column_class = "w-full teaser-single-column";
      break;

    case '2':
      $column_class = "w-full md__w-1/2 teaser-multi-column";
      break;

    case '4':
      $column_class = "w-full md__w-1/2 lg__w-1/4 teaser-multi-column";
      break;

    default:
      $column_class = "w-full md__w-1/2 lg__w-1/3 teaser-multi-column";

    break;
  }

  switch($select_type) {
    case "latestposts":
      $args = array(
        'posts_per_page' => $n ? $n : '0',
        'post_type' => 'post',
      );
      $posts = get_posts($args);
    break;
    case "select":
      if($selected) {
        $posts = $selected;
      }else {
        _e('Select at least one post','muy-lindo'); 
      }
    break;
    case "category":
      if($category) {
        $args = array(
          'posts_per_page' => $n ? $n : '0',
          'post_type' => 'post',
          'tax_query' => array(
            array(
              'taxonomy' => 'category',
              'terms'    => $category,
            ),
          ),
        );
      $posts = get_posts($args);
      }else {
        _e('Select a category','muy-lindo'); 
      }
      break;
    default:
      _e('Nothing to show','muy-lindo'); 
  }
@endphp

<div id="{{ esc_attr($id) }}" class="{{ esc_attr($className) }}">
  <div class="-mx-4 row">
    @php
      global $post;
    @endphp
    @foreach($posts as $post)
      <div class="{{ $column_class }}">
        @include('partials.teaser', ['titleColor' => $title_color, 'excerptColor' => $excerpt_color, 'catColor' => $cta_color,])
      </div>
    @endforeach
  </div><!--row-->
</div>
