@php
  /**
   * @param   array $block The block settings and attributes.
   * @param   string $content The block inner HTML (empty).
   * @param   bool $is_preview True during AJAX preview.
   * @param   (int|string) $post_id The post ID this block is saved to.
   */

  $id = 'muy-products-list' . $block['id'];
  if( !empty($block['anchor']) ) {
    $id = $block['anchor'];
  }

  $className = 'muy-'.$block['slug'];
  if( !empty($block['className']) ) {
    $className .= ' container ' . $block['className'];
  }
  if( !empty($block['align']) ) {
    $className .= ' align' . $block['align'];
  }


  $products_teaser_image_height = get_field('products_teaser_image_height','muy-height-md');
  $products_per_row = get_field('products_per_row');
  $products = '';
  $selected = get_field('selected_products');
  $category = get_field('products_print_category');
  $select_type = get_field('products_select_type');
  $n = get_field('products_number');
  $title_color = get_field('title_color');
  $excerpt_color = get_field('excerpt_color');
  $cta_color = get_field('cta_color');

  switch ($products_per_row) {
    case '1':
      $column_class = "w-full teaser-single-column";
      break;

    case '2':
      $column_class = "w-full md__w-1/2 teaser-multi-column";
      break;

    case '4':
      $column_class = "w-full md__w-1/2 lg__w-1/4 teaser-multi-column";
      break;

    default:
      $column_class = "w-full md__w-1/2 lg__w-1/3 teaser-multi-column";

    break;
  }

  switch($select_type) {
    case "latestproducts":
      $args = array(
        'posts_per_page' => $n ? $n : '0',
        'post_type' => 'product',
      );
      $products = get_posts($args);
      break;
    case "select":
      if($selected) {
        $products = $selected;
      }else {
        _e('Select at least one '. $singular_name ,'muy-lindo'); 
      }
      break;
    case "category":
      if($category) {
        $args = array(
          'posts_per_page' => $n ? $n : '0',
          'post_type' => 'product',
          'tax_query' => array(
            array(
              'taxonomy' => 'category-product',
              'terms'    => $category,
            ),
          ),
        );
      $products = get_posts($args);
      }else {
        _e('Select a category','muy-lindo'); 
      }
      break;
    default:
      _e('Nothing to show','muy-lindo'); 
  }

@endphp

<div id="{{ esc_attr($id) }}" class="{{ esc_attr($className) }}">
  <div class="-mx-8 row">
    @php
      global $post;
    @endphp
    @foreach($products as $post)
      <div class="{{ $column_class }}">
        @include('partials.teaser-product', ['titleColor' => $title_color, 'excerptColor' => $excerpt_color, 'catColor' => $cta_color,])
      </div>
    @endforeach
  </div><!--row-->
</div>
