@php
  /**
   * Rounded Card Block Template.
   *
   * @param   array $block The block settings and attributes.
   * @param   string $content The block inner HTML (empty).
   * @param   bool $is_preview True during AJAX preview.
   * @param   (int|string) $post_id The post ID this block is saved to.
   */

  // Create id attribute allowing for custom "anchor" value.
  $id = 'muy-' . $block['id'];
  if( !empty($block['anchor']) ) {
    $id = $block['anchor'];
  }

  // Create class attribute allowing for custom "className" and "align" values.
  $className = 'muy-' . $block['slug'];
  if (!empty($block['className'])) {
      $className .= ' ' . $block['className'];
  }
@endphp

<div id="{{ esc_attr($id) }}" class="{{ esc_attr($className) }}">
  <div class="card-inner">
    <InnerBlocks />
  </div>
</div>
