@php
  /**
   * @param   array $block The block settings and attributes.
   * @param   string $content The block inner HTML (empty).
   * @param   bool $is_preview True during AJAX preview.
   * @param   (int|string) $post_id The post ID this block is saved to.
   */

  $id = 'muy-services-list' . $block['id'];
  if( !empty($block['anchor']) ) {
    $id = $block['anchor'];
  }

  $className = 'muy-'.$block['slug'];
  if( !empty($block['className']) ) {
    $className .= ' container ' . $block['className'];
  }
  if( !empty($block['align']) ) {
    $className .= ' align' . $block['align'];
  }

  $singular_name = get_field('service_singular_name', 'options') ?: 'service';
  $services_teaser_image_height = get_field('services_teaser_image_height','muy-height-md');
  $services_per_row = get_field('services_per_row');
  $services = '';
  $selected = get_field('selected_services');
  $category = get_field('services_print_category');
  $select_type = get_field('services_select_type');
  $n = get_field('services_number');
  $title_color = get_field('title_color');
  $excerpt_color = get_field('excerpt_color');
  $cta_color = get_field('cta_color');

  switch ($services_per_row) {
    case '1':
      $column_class = "w-full teaser-single-column";
      break;

    case '2':
      $column_class = "w-full md__w-1/2 teaser-multi-column";
      break;

    case '4':
      $column_class = "w-full md__w-1/2 lg__w-1/4 teaser-multi-column";
      break;

    default:
      $column_class = "w-full md__w-1/2 lg__w-1/3 teaser-multi-column";

    break;
  }

  switch($select_type) {
    case "latestservices":
      $args = array(
        'posts_per_page' => $n ? $n : '0',
        'post_type' => 'service',
      );
      $services = get_posts($args);
      break;
    case "select":
      if($selected) {
        $services = $selected;
      }else {
        _e('Select at least one ' . $singular_name,'muy-lindo'); 
      }
      break;
    case "category":
      if($category) {
        $args = array(
          'posts_per_page' => $n ? $n : '0',
          'post_type' => 'service',
          'tax_query' => array(
            array(
              'taxonomy' => 'category-service',
              'terms'    => $category,
            ),
          ),
        );
      $services = get_posts($args);
      }else {
        _e('Select a category','muy-lindo'); 
      }
      break;
    default:
      _e('Nothing to show','muy-lindo'); 
  }
@endphp

<div id="{{ esc_attr($id) }}" class="{{ esc_attr($className) }}">
  <div class="-mx-8 row">
    @php
      global $post;
    @endphp
    @foreach($services as $post)
      <div class="{{ $column_class }}">
        @include('partials.teaser-service', ['titleColor' => $title_color, 'excerptColor' => $excerpt_color, 'catColor' => $cta_color,])
      </div>
    @endforeach
  </div><!--row-->
</div>
