@php
  /**
   * Testimonial Block Template.
   *
   * @param   array $block The block settings and attributes.
   * @param   string $content The block inner HTML (empty).
   * @param   bool $is_preview True during AJAX preview.
   * @param   (int|string) $post_id The post ID this block is saved to.
   */

  // Create id attribute allowing for custom "anchor" value.
  $id = 'muy-slide-' . $block['id'];
  if( !empty($block['anchor']) ) {
    $id = $block['anchor'];
  }

  // Create class attribute allowing for custom "className" and "align" values.
  $className = 'muy-'.$block['slug'];

  if( !empty($block['className']) ) {
    $className .= ' ' . $block['className'];
  }
  if( !empty($block['align']) ) {
    $className .= ' align' . $block['align'];
  }

  $allowed_blocks = array( 'core/image', 'core/paragraph' );
@endphp

<div id="{!! esc_attr($id) !!}" class="{!! esc_attr($className); !!} slide">
  <InnerBlocks/>
</div>