@php
  /*
  * Nei template dei blocchi creati con ACF non sarà possibile usare blade
  * perchè non viene interpretato nella preview in admin
  */

  // Create id attribute allowing for custom "anchor" value.
  $id = 'muy-slider-' . $block['id'];
  if( !empty($block['anchor']) ) {
    $id = $block['anchor'];
  }

  // Create class attribute allowing for custom "className" and "align" values.
  $className = 'muy-'.$block['slug'];
  if( !empty($block['className']) ) {
    $className .= ' ' . $block['className'];
  }
  if( !empty($block['align']) ) {
    $className .= ' align' . $block['align'];
  }

  $default_slides = array(
    array(
      'text'  => __('Insert first slide', 'muy-lindo'),
    ),
  );

  // Load values and assign defaults.
  $slides = get_field('slides') ?: $default_slides;

  $dots = get_field('dots') ?: false;
  $next_arrow = get_field('next_arrow');
  $pause_on_hover = get_field('pause_on_hover');
  $before_arrow = get_field('before_arrow');
  $autoplay_speed = get_field('autoplay_speed');
  $max_width_content = get_field('max_width_content');
  $infinite = get_field('infinite') ?: false;
  $dots_color = get_field('dots_color');
  $dots_position = (int) get_field('dots_position');
  $autoplay = get_field('autoplay') ?: false;
  //slick slide crashes with infinite on false and slide to show on 0
  $slides_to_show = (int) get_field('slides_to_show');
  $arrows = get_field('arrows') ?: false;
  $slider_height = get_field('slider_height') ?: false;
  $slider_height_mobile = get_field('slider_height_mobile') ?: false;

  switch ($slides_to_show) {
    case 4:
      $slides_to_show_screen_lg = 3;
      $slides_to_show_screen_md = 2;
      $slides_to_show_screen_sm = 1;
      break;
    case 3:
      $slides_to_show_screen_lg = 3;
      $slides_to_show_screen_md = 2;
      $slides_to_show_screen_sm = 1;
      break;
    case 2:
      $slides_to_show_screen_lg = 2;
      $slides_to_show_screen_md = 1;
      $slides_to_show_screen_sm = 1;
      break;
    default:
      $slides_to_show_screen_lg = 1;
      $slides_to_show_screen_md = 1;
      $slides_to_show_screen_sm = 1;
    break;
  }

  switch ($max_width_content) {
    case 380:
      $max_width_content_xs = 'max_width_content_xs';
      break;
    case 500:
      $max_width_content_sm = 'max_width_content_sm';
    case 650:
      $max_width_content_md = 'max_width_content_md';
      break;
    case 768:
      $max_width_content_lg = 'max_width_content_lg';
      break;
    case 1024:
      $max_width_content_xl = 'max_width_content_xl';
      break;
    case 1280:
      $max_width_content_2xl = 'max_width_content_2xl';
      break;
    default:
      $max_width_content_default = '';
    break;
  }

  $slick_options = array(
    'dots' => $dots,
    'infinite' => $infinite,
    'autoplay' => $autoplay,
    'autoplaySpeed'=> $autoplay_speed,
    'arrows' => $arrows,
    'pauseOnHover' => $pause_on_hover,
    'slidesToShow' => $slides_to_show,
    'prevArrow' => ".before-arrow",
    'nextArrow' => ".next-arrow",
    'responsive' => [
      array(
      'breakpoint' => 1024,
      'settings' => array(
        'slidesToShow' => $slides_to_show_screen_lg,
        'arrows' => false, 
        ),
      ),
      array(
      'breakpoint' => 870,
      'settings' => array(
        'slidesToShow' => $slides_to_show_screen_md,
        'arrows' => false, 
        ),
      ),
      array(
      'breakpoint' => 640,
      'settings' => array(
        'slidesToShow' => $slides_to_show_screen_sm,
        'arrows' => false,
        ),
      ),
    ],
  );


@endphp

<div id="{{ esc_attr($id) }}" class="{{ esc_attr($className) }}">
  @if ($slides)
    @if($arrows)
      <button
        type="button"
        @if ($before_arrow)  
        style="background-image: url('{!! $before_arrow['url'] !!}')"
        @endif
        class="{{ !$before_arrow ?: 'image-arrow' }} slick-arrow before-arrow slick-prev"
      >
      </button>
      <button
        type="button"
        @if ($next_arrow)  
        style="background-image: url('{!! $next_arrow['url'] !!}')"
        @endif 
        class="{{ !$next_arrow ?: 'image-arrow' }} slick-arrow next-arrow slick-next"
      >
      </button>
    @endif
    
    <div class="slider" data-slick="{!! esc_attr(json_encode($slick_options)) !!}">
      @foreach ($slides as $slide)
        @php
          $cta_invert = $slide['cta_invert'] ?: false;
          $btn_background_color = $slide['button_background_color'];
          $btn_text_color = $slide['button_text_color'];
        @endphp

        <div class="slide @if($slider_height) {!! $slider_height !!} @endif @if($slider_height_mobile) {!! $slider_height_mobile !!} @endif {!! $slide['text'] ? 'slide-has-text' : 'slide-no-text' !!}">

            <figure 
                class="@if($slider_height) {!! $slider_height !!} @endif" 
                style="@if($slides_to_show > 1) margin: 0 5px; @endif background-color: @if($slide['background_color']) {!! $slide['background_color'] !!} @endif">

              @if ($slide['image'])
                <img class="@if($slide['image_mobile']) desktop @endif" style="opacity: @if($slide['background_opacity']) {!! $slide['background_opacity'] !!} @endif" 
                     src="{!! $slide['image']['sizes']['full_hd'] !!}" />
              @endif

              @if ($slide['image_mobile'])
                <img class="mobile" style="opacity: @if($slide['background_opacity']) {!! $slide['background_opacity'] !!} @endif" 
                     src="{!! $slide['image_mobile']['sizes']['full_hd'] !!}" />
              @endif

            </figure>

            <div class="mt-1 slider-content {{ $max_width_content_xs }} {{ $max_width_content_sm }} {{ $max_width_content_md }} {{ $max_width_content_lg }} {{ $max_width_content_xl }} {{ $max_width_content_2xl }}" style="text-align: {!! $slide['align'] !!}"> 
                {!! $slide['text'] !!}
                @if($slide['cta'])
                <a 
                  class="btn @if($cta_invert) invert @endif" 
                  style="color: {!! $btn_text_color !!} !important;
                     @if(!($cta_invert)) background-color:{!! $btn_background_color !!}; @endif
                     @if($cta_invert) border: 1px solid {!! $btn_background_color !!}; @endif"
                  href="{{ $slide['cta']['url'] }}" target="{{ $slide['cta']['target'] }}" 
                  title="{{ $slide['link']['title'] }}">
                    {{ $slide['cta']['title'] }}
                </a>
                @endif
            </div>
        </div>
      @endforeach
    </div>
  @endif

  <style>
    #{{ esc_attr($id) }}.muy-slider .slider .slick-dots li.slick-active button::before {
      background-color: {!! $dots_color !!};
    }

    #{{ esc_attr($id) }}.muy-slider .slider .slick-dots li button::before {
      border-color: {!! $dots_color !!};
    }

    #{{ esc_attr($id) }} .slick-dots {
      position: relative;
      bottom: {!! $dots_position !!}px;
    }
  </style>
</div>