@php
  /**
   * Team List Block Template.
   *
   * @param   array $block The block settings and attributes.
   * @param   string $content The block inner HTML (empty).
   * @param   bool $is_preview True during AJAX preview.
   * @param   (int|string) $post_id The post ID this block is saved to.
   */

  // Create id attribute allowing for custom "anchor" value.
  $id = 'muy-' . $block['id'];
  if( !empty($block['anchor']) ) {
    $id = $block['anchor'];
  }

  // Create class attribute allowing for custom "className" and "align" values.
  $className = 'muy-'.$block['slug'];
  if( !empty($block['className']) ) {
    $className .= ' ' . $block['className'];
  }
  if( !empty($block['align']) ) {
    $className .= ' align' . $block['align'];
  }

  $team = get_field('team');
@endphp

<div id="{{ esc_attr($id) }}" class="{{ esc_attr($className) }}">
  @if($team)
    <div class="team-list-inner">
      @foreach ($team as $item)
        @php
            $image = $item['image'];
            $name = $item['name'];
            $info = $item['info'];
            $text = $item['text'];
        @endphp
        <div class="card-inner">
          <figure class="card-figure">
            <img 
              class="lazy"
              src="{!! $image['sizes']['large'] !!}"
              alt="{!! $image['alt'] !!}"
            />
            @if($text)
              <div class="card-text">
                {!! $text !!}
              </div>
            @endif
          </figure>
          <div class="card-details">
            @if($name)
              <h3>
                {!! $name !!}
              </h3>
            @endif
            @if($info)
              <div class="card-info">
                {!! $info !!}
              </div>
            @endif
          </div>
        </div>
      @endforeach
    </div>
  @endif
</div>