@php
  $muy_header_transparent = get_theme_mod('muy_header_transparent', false);
  $muy_header_fixed = get_theme_mod('muy_header_fixed');
@endphp
<!doctype html>
<html {!! get_language_attributes() !!}>
  @include('partials.head')
  <body @php body_class() @endphp>
    @php
      do_action('in_body');
    @endphp
    <main id="app">
      @php do_action('get_header') @endphp
      @include('partials.header')
      <div class="
        wrap
        @if($muy_header_transparent && $muy_header_fixed) transparent-bg-fixed @endif
        @if($muy_header_fixed) header-fixed @endif
      " role="document">
        <div class="content">
          <main class="main">
            @yield('content')
          </main>
          @if (App\display_sidebar())
            <aside class="sidebar">
              @include('partials.sidebar')
            </aside>
          @endif
        </div>
      </div>

      @php do_action('get_footer') @endphp
      @include('partials.footer')
    </main>
    @php wp_footer() @endphp
  </body>
</html>
