@php

namespace App;

  $muy_header_type = get_theme_mod('muy_header_type','header-1');
  $muy_header_search_toggle = get_theme_mod('muy_header_search_toggle',true);
  $muy_search_button_style = get_theme_mod('muy_search_button_style');
  $muy_header_logo = get_theme_mod('muy_header_logo');
  $muy_header_logo_secondary = get_theme_mod('muy_header_logo_secondary');
  $muy_pre_header_toggle = get_theme_mod('muy_pre_header_toggle',false);
  $muy_without_header = get_theme_mod('muy_without_header', false);
  $muy_header_scroll_hide = get_theme_mod('muy_header_scroll_hide', false);
  $muy_header_transparent = get_theme_mod('muy_header_transparent', false);
  $muy_header_fixed = get_theme_mod('muy_header_fixed');
  // acf get fields general options
  $cta_header_padding_top = get_field('cta_header_padding_top', 'option');
  $cta_header_padding_bottom = get_field('cta_header_padding_bottom', 'option');
  $cta_header_padding_left = get_field('cta_header_padding_left', 'option');
  $cta_header_padding_right = get_field('cta_header_padding_right', 'option');
  $cta_header_bg_color_overlay = get_field('cta_header_bg_color_overlay', 'option');
  $cta_header_border_radius = get_field('cta_header_border_radius', 'option') ? get_field('cta_header_border_radius', 'option') : 0;

@endphp

<header class="main-header
  @if($muy_header_scroll_hide) scroll-hide @endif
  @if($muy_header_transparent) transparent-bg @endif
  @if($muy_header_transparent && $muy_header_fixed) transparent-bg-fixed @endif
  ">

  @include('partials.overlay-menu')

  @if($muy_pre_header_toggle)
    @include('partials.pre-header')
  @endif

@if ($muy_header_type && !$muy_without_header)
  @include('partials.headers.'.$muy_header_type, array(
    'show_search' => $muy_header_search_toggle,
    'header_logo' => $muy_header_logo,
    'header_logo_invert' => $muy_header_logo_secondary,
    'button_style' => $muy_search_button_style,
  ))
@endif

</header>

<style lang="scss">
  .main-header .items-right .navbar-right .nav li.btn a {
    border-radius: {{ $cta_header_border_radius }}px;
    padding: {{ $cta_header_padding_top }}px {{ $cta_header_padding_right }}px {{ $cta_header_padding_bottom }}px {{ $cta_header_padding_left }}px;
  }

  .main-header.active .items-right .navbar-right .nav li.btn a {
    background-color: {{ $cta_header_bg_color_overlay }} !important;
  }

</style>