@php
global $post;
$muy_services_teaser_taxonomy_toggle = get_theme_mod('muy_services_teaser_taxonomy_toggle');
$muy_services_teaser_image_toggle = get_theme_mod('muy_services_teaser_image_toggle');
$muy_services_teaser_image_placeholder = get_theme_mod('muy_services_teaser_image_placeholder');
$muy_services_teaser_image_height = get_theme_mod('muy_services_teaser_image_height');
$muy_services_teaser_category_toggle = get_theme_mod('muy_services_teaser_category_toggle');
$muy_services_teaser_showmore = get_theme_mod('muy_services_teaser_showmore');
$muy_services_teaser_excerpt_toggle = get_theme_mod('muy_services_teaser_excerpt_toggle');
@endphp
<style>
  .teaser-service .entry-summary p {
    color: {!! $excerpt_color !!};
  }
</style>

<article {!! post_class('teaser-service') !!}>
  @if ($muy_services_teaser_image_toggle)
    <div class="figure-wrapper">
      <figure>
        <a href="{{ get_permalink($post->ID) }}" title="{!! get_the_title($post->ID) !!}">
          @if (has_post_thumbnail($post->ID))
            <img data-mh="teaser-post" class="lazy @if ($muy_services_teaser_image_height) {!! $muy_services_teaser_image_height !!} @endif"
              src="{!! get_the_post_thumbnail_url($post->ID, 'medium') !!}" data-src="{!! get_the_post_thumbnail_url($post->ID, 'large') !!}" />
          @elseif($muy_services_teaser_image_placeholder)
            <img data-mh="teaser-post" class="lazy @if ($muy_services_teaser_image_height) {!! $muy_services_teaser_image_height !!} @endif"
              src="{!! wp_get_attachment_url($muy_services_teaser_image_placeholder, 'medium') !!}" data-src="{!! wp_get_attachment_url($muy_services_teaser_image_placeholder, 'large') !!}" />
          @endif

        </a>
      </figure>
    </div>
  @endif

  <div class="teaser-content">
    <header>
      <a href="{{ get_permalink($post->ID) }}" title="{!! get_the_title($post->ID) !!}">
        <h2 class="teaser-title" style="color: {!! $titleColor !!}">
          {!! get_the_title($post->ID) !!}
        </h2>
      </a>
    </header>

    <div class="entry-summary">
      @if ($muy_services_teaser_excerpt_toggle)
        @php
          the_excerpt($post->ID);
        @endphp
      @endif
    </div>

    <div class="teaser-info">
      @if ($muy_services_teaser_category_toggle)
        @php $categories = get_the_category(); @endphp
        @foreach ($categories as $category)
          <a href="{!! get_category_link($category->cat_ID) !!}">
            {!! $category->name !!}
          </a>
        @endforeach
      @endif

      @if ($muy_services_teaser_date_toggle)
        <time class="updated" datetime="{{ get_post_time('c', true) }}">
          {{ get_the_date() }}
        </time>
      @endif
    </div>
    <div>
      <a class="@if ($muy_services_teaser_showmore) {!! $muy_services_teaser_showmore !!} @endif mt-6 text-sm"
        href="{!! esc_url(get_permalink($post->ID)) !!}" style="color: {!! $cta_color !!}">
        {!! __('Leggi di più', 'muy-lindo') !!}
      </a>
    </div>
  </div>
</article>
