@php
global $post;
$muy_posts_teaser_date_toggle = get_theme_mod('muy_posts_teaser_date_toggle', true);
$muy_posts_teaser_category_toggle = get_theme_mod('muy_posts_teaser_category_toggle', true);
$muy_posts_teaser_image_toggle = get_theme_mod('muy_posts_teaser_image_toggle', true);
$muy_posts_teaser_image_placeholder = get_theme_mod('muy_posts_teaser_image_placeholder');
$muy_posts_teaser_excerpt_toggle = get_theme_mod('muy_posts_teaser_excerpt_toggle', true);
$muy_posts_teaser_image_height = get_theme_mod('muy_posts_teaser_image_height');
$muy_posts_teaser_showmore = get_theme_mod('muy_posts_teaser_showmore');
@endphp

<article {!! post_class('teaser-post') !!}>
  @if ($muy_posts_teaser_image_toggle)
    <div class="figure-wrapper">
      <figure>
        <a href="{{ get_permalink($post->ID) }}" title="{!! get_the_title($post->ID) !!}">

          @if (has_post_thumbnail($post->ID))
            <img class="lazy @if ($muy_posts_teaser_image_height) {!! $muy_posts_teaser_image_height !!} @endif"
              src="{!! get_the_post_thumbnail_url($post->ID, 'medium') !!}" data-src="{!! get_the_post_thumbnail_url($post->ID, 'large') !!}" />
          @elseif($muy_posts_teaser_image_placeholder)
            <img class="lazy @if ($muy_posts_teaser_image_height) {!! $muy_posts_teaser_image_height !!} @endif"
              src="{!! wp_get_attachment_url($muy_posts_teaser_image_placeholder, 'medium') !!}" data-src="{!! wp_get_attachment_url($muy_posts_teaser_image_placeholder, 'large') !!}" />
          @endif

        </a>
      </figure>
    </div>
  @endif

  <div class="teaser-content">

    <div class="teaser-info">
      @if ($muy_posts_teaser_category_toggle)
        @php $categories = get_the_category(); @endphp
        @foreach ($categories as $category)
          <a href="{!! get_category_link($category->cat_ID) !!}">
            {!! $category->name !!}
          </a>
        @endforeach
      @endif

      @if ($muy_posts_teaser_date_toggle)
        <time class="updated" datetime="{{ get_post_time('c', true) }}">
          {{ get_the_date() }}
        </time>
      @endif
    </div>

    <header>

      <a href="{{ get_permalink($post->ID) }}" title="{!! get_the_title($post->ID) !!}">
        <h2 class="teaser-title" style="color: {!! $titleColor !!}">
          {!! get_the_title($post->ID) !!}
        </h2>
      </a>
    </header>

    <div class="entry-summary" style="color: {!! $excerpt_color !!}">
      @if ($muy_posts_teaser_excerpt_toggle)
        @php
          the_excerpt($post->ID);
        @endphp
      @endif
    </div>

    <div>
      <a class="@if ($muy_posts_teaser_showmore) {!! $muy_posts_teaser_showmore !!} @endif mt-6 text-sm"
        href="{!! esc_url(get_permalink($post->ID)) !!}" style="color: {!! $cta_color !!}">
        {!! __('Leggi di più', 'muy-lindo') !!}
      </a>
    </div>
  </div>

</article>