@extends('layouts.app')

@php
  $muy_products_teaser_per_row = get_theme_mod('muy_products_teaser_per_row');

  switch ($muy_products_teaser_per_row) {
    case '1':
      $column_class = "w-full px-4 teaser-single-column";
    break;

    case '2':
      $column_class = "w-full md__w-1/2 px-4 teaser-multi-column";
    break;

    case '4':
      $column_class = "w-full md__w-1/2 lg__w-1/4 px-4 teaser-multi-column";
    break;

    default:
      $column_class = "w-full md__w-1/2 lg__w-1/3 px-4 teaser-multi-column";
    break;
  }

  $subcategories = get_terms( 'category-product', ['child_of' => get_queried_object()->term_id, 'hide_empty' => false]);
  // $taxonomy_image = get_field('taxonomy_image', get_queried_object());
  // $show_subcategories = get_field('show_subcategories', get_queried_object());
@endphp

@section('content')
  @include('partials.page-header')

  <div class="container">
    <div class="taxonomy-description">{!! term_description() !!}</div>
    @if (!have_posts())
      <div class="no-results-found">
        <div class="alert alert-warning">
          <h2>{{ __('Sorry, no results were found.', 'muy-lindo') }}</h2>
        </div>
        <div>
          <a href="{!! get_home_url(); !!}" class="btn">{!! __('Back to home','muy-lindo') !!}</a>
        <div>
      </div>
    @else
      <div class="-mx-4 row">
        @if ($show_subcategories)
          @foreach ($subcategories as $category)
            <div class="{{ $column_class }} teaser-subcategory ">
              <div class="content-wrapper {{ $layout }}" style="color: {{ $button_icon }}">
                <h3 style="color: {{ $category_color }}">
                  {{ $category->name}}
                </h3>

                <a href="{{ get_term_link($category) }}" class="btn bnt-teaser" style="border-color: {{ $category_color }}">
                  <img src="{!! $button_icon['url'] !!}" alt="">
                </a>
              </div>
            </div>
          @endforeach
        @else
          @while (have_posts())
            @php the_post() @endphp
            <div class="{{ $column_class }}">
              @include('partials.teaser-'.get_post_type())
            </div>
          @endwhile
        @endif
      </div><!--row-->
    @endif

    @php
      wp_reset_query();
    @endphp

  </div><!--container-->
@endsection
