@php
  /**
   * Testimonial Block Template.
   *
   * @param   array $block The block settings and attributes.
   * @param   string $content The block inner HTML (empty).
   * @param   bool $is_preview True during AJAX preview.
   * @param   (int|string) $post_id The post ID this block is saved to.
   */

  // Create id attribute allowing for custom "anchor" value.
  $id = 'thor-posts-featured-slider' . $block['id'];
  if( !empty($block['anchor']) ) {
    $id = $block['anchor'];
  }

  // Create class attribute allowing for custom "className" and "align" values.
  $className = 'thor-'.$block['slug'];

  if( !empty($block['className']) ) {
    $className .= ' ' . $block['className'];
  }
  if( !empty($block['align']) ) {
    $className .= ' align' . $block['align'];
  }

  $args_featured_home_post = [
  'post_status' => 'publish',
  'posts_per_page' => 100000,
  'offset' => 3,
  'meta_key'		=> 'featured_home_post',
  'meta_value'	=> true,
  ];
  $featured_home_post = get_posts($args_featured_home_post);
@endphp

<div id="{!! esc_attr($id) !!}" class="{!! esc_attr($className); !!}">
  <div class="featured-slider ">
    <div class="section-header">
      <div class="section-divider"></div>
      <div class="flex justify-between">
        <h3 class="section-title">{!! __('In evidenza', 'thor') !!}</h3>
        <a class="link-archive" href="{!! get_category_link(  get_cat_ID('news') ) !!}">
          {!! __('Vedi tutte', 'thor') !!}
          @svg('images/arrow-right-archive.svg')
        </a>
      </div>
    </div>

    <div class="bg-gray-100">
      <div class="title-section-mobile">
        <div class="section-divider"></div>
        <div class="flex justify-between">
          <h3 class="section-title">{!! __('In evidenza', 'thor') !!}</h3>
        </div>
      </div>
      <div class="swiper-container slider-home">
        <div class="swiper-wrapper">
          @foreach ($featured_home_post as $slide)
            @php
              $post_badge = get_field('lioit_post_badge_text', $slide->ID);
              $term = get_the_terms( $slide->ID, 'category' );
            @endphp
            <article class="swiper-slide post-teaser">
              <span class="post-badge">
                  @if ($post_badge)
                    {!! $post_badge !!}
                  @else
                    {!! $term[0]->name !!}
                  @endif
                <time
                  class="updated mobile"
                  datetime="{{ get_post_time('d F o', true) }}">
                  {{ get_the_date('d F o', $featured->ID) }}
                </time>
              </span>
              <div class="teaser-mobile">
                @if (has_post_thumbnail($slide->ID))
                  <figure>
                    <a href="{{ get_permalink($slide->ID) }}" title="{!! get_the_title($slide->ID) !!}">
                      <img
                        class="lazy"
                        src="{!! get_the_post_thumbnail_url($slide->ID, 'mini') !!}"
                        data-src="{!! get_the_post_thumbnail_url($slide->ID, 'large') !!}"
                      />
                    </a>
                  </figure>
                @endif

                <div>
                  <header>
                    <a href="{{ get_permalink($slide->ID) }}" title="{!! get_the_title($slide->ID) !!}">
                      <h2>
                        {!! get_the_title($slide->ID) !!}
                      </h2>
                    </a>
                  </header>
                  <time
                    class="updated"
                    datetime="{{ get_post_time('d F o', true) }}">
                    {{ get_the_date('d F o', $slide->ID) }}
                  </time>
                </div>
              </div>
              
            </article>
          @endforeach
        </div>

        <div class="pagination-wrapper">
          <div class="custom-button-prev">
            <img src="@asset('images/chevron-left.svg')" alt="{{ __('circle-chevron-left', 'thor') }}">
          </div>
          <div class="swiper-pagination"></div>
          <div class="custom-button-next">
            <img src="@asset('images/chevron-right.svg')" alt="{{ __('circle-chevron-right', 'thor') }}">
          </div>
        </div>

        <a class="link-archive" href="{!! get_category_link(  get_cat_ID('news') ) !!}">
          {!! __('Vedi tutte', 'thor') !!}
          @svg('images/arrow-right-archive.svg')
        </a>
      </div>
    </div>
  </div>



  <div class="featured-slider alignfull mobile">
    <div class="section-header">
      <div class="section-divider"></div>
      <div class="flex justify-between">
        <h3 class="section-title">{!! __('In evidenza', 'thor') !!}</h3>
        <a class="link-archive" href="{!! get_category_link(  get_cat_ID('news') ) !!}">
          {!! __('Vedi tutte', 'thor') !!}
          @svg('images/arrow-right-archive.svg')
        </a>
      </div>
    </div>

    <div class="bg-gray-100">
      <div class="title-section-mobile">
        <div class="section-divider"></div>
        <div class="flex justify-between">
          <h3 class="section-title">{!! __('In evidenza', 'thor') !!}</h3>
        </div>
      </div>
      <div class="swiper-container slider-home">
        <div class="swiper-wrapper">
          @foreach ($featured_home_post as $key => $slide)
            @php
              $post_badge = get_field('lioit_post_badge_text', $slide->ID);
              $term = get_the_terms( $slide->ID, 'category' );
            @endphp

            @if ($key % 3 == 0) 
              <div class = "swiper-slide">
            @endif

              <article class="post-teaser">
                <span class="post-badge">
                  @if ($post_badge)
                      {!! $post_badge !!}
                  @else
                    {!! $term[0]->name !!}
                  @endif
                  <time
                    class="updated mobile"
                    datetime="{{ get_post_time('d F o', true) }}">
                    {{ get_the_date('d F o', $featured->ID) }}
                  </time>
                </span>
                <div class="teaser-mobile">
                  @if (has_post_thumbnail($slide->ID))
                    <figure>
                      <a href="{{ get_permalink($slide->ID) }}" title="{!! get_the_title($slide->ID) !!}">
                        <img
                          class="lazy"
                          src="{!! get_the_post_thumbnail_url($slide->ID, 'mini') !!}"
                          data-src="{!! get_the_post_thumbnail_url($slide->ID, 'large') !!}"
                        />
                      </a>
                    </figure>
                  @endif

                  <div>
                    <header>
                      <a href="{{ get_permalink($slide->ID) }}" title="{!! get_the_title($slide->ID) !!}">
                        <h2>
                          {!! get_the_title($slide->ID) !!}
                        </h2>
                      </a>
                    </header>
                    <time
                      class="updated"
                      datetime="{{ get_post_time('d F o', true) }}">
                      {{ get_the_date('d F o', $slide->ID) }}
                    </time>
                  </div>
                </div>
                
              </article>

            @if ($key % 3 == 2) 
              </div>
            @endif
          @endforeach
        </div>

        <div class="pagination-wrapper">
          <div class="custom-button-prev">
            <img src="@asset('images/chevron-left.svg')" alt="{{ __('circle-chevron-left', 'thor') }}">
          </div>
          <div class="swiper-pagination"></div>
          <div class="custom-button-next">
            <img src="@asset('images/chevron-right.svg')" alt="{{ __('circle-chevron-right', 'thor') }}">
          </div>
        </div>

        <a class="link-archive" href="{!! get_category_link(  get_cat_ID('news') ) !!}">
          {!! __('Vedi tutte', 'thor') !!}
          @svg('images/arrow-right-archive.svg')
        </a>
      </div>
    </div>
  </div>
</div>