@php
  $images_gallery = get_field('images_gallery');
  $post_type = get_post_type( get_the_ID() );
  $archive_link = get_post_type_archive_link($post_type);

  $args_related_products = [
    'post_type' => get_post_type( get_the_ID() ),
    'post_status' => 'publish',
    'post__not_in' => [get_the_ID()],
    'posts_per_page' => -1,
    'meta_query' => [
      [
        'key'   => 'product_relation_with_company',
        'value' => $related_company[0],
        'compare' => 'LIKE',
      ],
    ],
  ];

  $related_products = get_posts($args_related_products);
@endphp

<article {!! post_class('single-post-wrapper') !!}>
  <div class="wrapper-back-to-archive">
    <a href="{{ $archive_link }}" class="back-to-archive">
      {!! __('Torna agli eventi', 'thor') !!}
      @svg('images/arrow-teaser-archive.svg')
    </a>
  </div>

  @include('partials/page-header')

  <div class="container">

    <div class="single-post-inner clearfix">
      <div class="post-content-wrapper">
        <div class="content">
          <figure class="main-image">
            <a href="{!! get_the_post_thumbnail_url(get_the_ID(), 'full') !!}">
              <img
                class="lazy"
                src="{!! get_the_post_thumbnail_url(get_the_ID(), 'thumbnail') !!}"

                data-src="{!! get_the_post_thumbnail_url(get_the_ID(), 'large') !!}"

              />
            </a>
          </figure>
          <h1 class="title">{!! App::title() !!}</h1>
          @php the_content() @endphp
          <div class="share">
            <h5>
              {!! __('Condividi', 'thor') !!}
            </h5>
            <social-sharing-link
              url="{!! esc_attr(get_the_permalink()) !!}"
            />
          </div><!--share-->

          <div class="gallery">
            @foreach ($images_gallery as $image)
              <a class="image-slide glightbox" href="{!! $image['url'] !!}">
                <figure>
                  <img src="{!! $image['url'] !!}" alt="">
                </figure>
              </a>
            @endforeach
          </div>
        </div>

        <div class="right-content-wrapper">
          <div class="adv-wrapper">
            @include('partials.adv-box')
            @include('partials.adv-box')
            @include('partials.adv-box')
            @include('partials.adv-halfpage')
          </div>
        </div>
      </div>
    </div><!--single-post-inner-->
  </div><!--container-->
</article>
