@php
  $args_random_posts = [
  'orderby'        => 'rand',
  'post_status' => 'publish',
  'posts_per_page' => 4,
  'category_name' => 'news',
  'date_query' => [
        [
          'after'   => '-1 month',
        ],
    ],
  ];
  $random_posts = get_posts($args_random_posts);
@endphp

<div class="more-news">
  <div class="section-divider"></div>
  <h3 class="section-title">{!! __('Altre News', 'thor') !!}</h3>

  <div class="teaser-wrapper">
    @foreach ($random_posts as $random)
      @php
        $post_badge = get_field('lioit_post_badge_text', $random->ID);
        $term = get_the_terms( $random->ID, 'category' );
      @endphp
      <article class="post-teaser">
        <span class="post-badge">
              @if ($post_badge)
                  {!! $post_badge !!}
              @else
                {!! $term[0]->name !!}
              @endif
              <time
                class="updated mobile"
                datetime="{{ get_post_time('d F o', true) }}">
                {{ get_the_date('d F o', $featured->ID) }}
              </time>
            </span>
        <header>
          <a href="{{ get_permalink($random->ID) }}" title="{!! get_the_title($random->ID) !!}">
            <h2>
              {!! get_the_title($random->ID) !!}
            </h2>
          </a>
        </header>
      </article>
    @endforeach
  </div>
  <a class="link-archive" href="{!! get_category_link(  get_cat_ID('news') ) !!}">
    {!! __('Vedi tutte', 'thor') !!}
    @svg('images/arrow-right-archive.svg')
  </a>
</div>