<?php

namespace App\Controllers;

use Sober\Controller\Controller;

class App extends Controller
{
    public function siteName()
    {
        return get_bloginfo('name');
    }

    public static function title()
    {
        if (is_home()) {
            if ($home = get_option('page_for_posts', true)) {
                return get_the_title($home);
            }
            return __('Latest Posts', 'thor');
        }
        if (is_archive()) {
            return get_the_archive_title();
        }
        if (is_search()) {
            return sprintf(__('Search Results for %s', 'thor'), get_search_query());
        }
        if (is_404()) {
            return __('Not Found', 'thor');
        }
        return get_the_title();
    }

    public static function socialbar()
    {
        if(function_exists('get_field'))
        {
        $html = '<div class="socialbar-container"><div class="socialbar">';
            if(get_field('facebook','option')) $html .= '<a href="'.esc_url(get_field('facebook','option')).'" target="_blank" title="'.__('Facebook','thor').'" class="facebook"><span class="icon-facebook"></span></a>';
            if(get_field('twitter','option')) $html .= '<a href="'.esc_url(get_field('twitter','option')).'" target="_blank" title="'.__('Twitter','thor').'" class="twitter"><span class="icon-twitter"></span></a>';
            if(get_field('whatsapp','option')) $html .= '<div><a href="https://api.whatsapp.com/send?phone='.get_field('whatsapp','option').'" target="_blank" title="'.__('Whatsapp','thor').'" class="whatsapp"><span class="icon-whatsapp"></span></a></div>';
            if(get_field('youtube','option')) $html .= '<a href="'.esc_url(get_field('youtube','option')).'" target="_blank" title="'.__('YouTube','thor').'" class="youtube"><span class="icon-youtube"></span></a>';
            if(get_field('vimeo','option')) $html .= '<a href="'.esc_url(get_field('vimeo','option')).'" target="_blank" title="'.__('Vimeo','thor').'" class="vimeo"><span class="icon-vimeo"></span></a>';
            if(get_field('linkedin','option')) $html .= '<a href="'.esc_url(get_field('linkedin','option')).'" target="_blank" title="'.__('LinkedIn','thor').'" class="linkedin"><span class="icon-linkedin"></span></a>';
            if(get_field('instagram','option')) $html .= '<a href="'.esc_url(get_field('instagram','option')).'" target="_blank" title="'.__('Instagram','thor').'" class="instagram"><span class="icon-instagram"></span></a>';
            if(get_field('pinterest','option')) $html .= '<a href="'.esc_url(get_field('pinterest','option')).'" target="_blank" title="'.__('Pinterest','thor').'" class="pinterest"><span class="icon-pinterest"></span></a>';
            if(get_field('flickr','option')) $html .= '<a href="'.esc_url(get_field('flickr','option')).'" target="_blank" title="'.__('Flickr','thor').'" class="flickr"><span class="icon-flickr"></span></a>';
        $html .= '</div></div>';

        return $html;
        }
    }

    public function credits()
    {
        return __('Designed and developed by <a href="https://dueper.net" target="_blank">Dueper Design</a>', 'thor');
    }
}
