@php
  $args_tickers_posts = [
    'post_type' => 'post',
    'post_status' => 'publish',
    'posts_per_page' => 10,
  ];
  $tickers_posts = get_posts($args_tickers_posts);
@endphp

<div class="ticker" id="ticker">
  <div class="badge">
    <span>●</span>
    <h4>{!! __('Ultime news', 'thor') !!}</h4>
  </div>

  <div class="ticker-wrap" id="ticker-wrap">
    @if ($tickers_posts)
      @foreach($tickers_posts as $item)
        @php
          $post_badge = get_field('lioit_post_badge_text', $item->ID);
          $term = get_the_terms( $item->ID, 'category' );
        @endphp
        <a href="{{ get_permalink($item) }}" title="{!! get_the_title($item) !!}">
            <span>
              @if ($post_badge)
                {!! $post_badge !!}
              @else
                {!! $term[0]->name !!}
              @endif
            </span>
            {!! get_the_title($item) !!}
        </a>
      @endforeach
    @endif
  </div>
</div>