<?php

namespace App;

/**
 * Add <body> classes
 */
add_filter('body_class', function (array $classes) {
    /** Add page slug if it doesn't exist */
    if (is_single() || is_page() && !is_front_page()) {
        if (!in_array(basename(get_permalink()), $classes)) {
            $classes[] = basename(get_permalink());
        }
    }

    /** Add class if sidebar is active */
    if (display_sidebar()) {
        $classes[] = 'sidebar-primary';
    }

    /** Clean up class names for custom templates */
    $classes = array_map(function ($class) {
        return preg_replace(['/-blade(-php)?$/', '/^page-template-views/'], '', $class);
    }, $classes);

    return array_filter($classes);
});

/**
 * Add "… Continued" to the excerpt
 */
add_filter('excerpt_more', function () {
    return ' &hellip; <a href="' . get_permalink() . '">' . __('Continued', 'thor') . '</a>';
});

/**
 * Template Hierarchy should search for .blade.php files
 */
collect([
    'index', '404', 'archive', 'author', 'category', 'tag', 'taxonomy', 'date', 'home',
    'frontpage', 'page', 'paged', 'search', 'single', 'singular', 'attachment', 'embed'
])->map(function ($type) {
    add_filter("{$type}_template_hierarchy", __NAMESPACE__.'\\filter_templates');
});

add_filter('get_the_archive_title', function ($title) {
    if (is_category()) {
        $title = single_cat_title('', false);
    } elseif (is_tag()) {
        $title = single_tag_title('', false);
    } elseif (is_author()) {
        $title = '<span class="vcard">' . get_the_author() . '</span>';
    } elseif (is_tax()) { //for custom post types
        $title = sprintf(__('%1$s'), single_term_title('', false));
    } elseif (is_post_type_archive()) {
        $title = post_type_archive_title('', false);
    }
    return $title;
});

/**
 * Render page using Blade
 */
add_filter('template_include', function ($template) {
    collect(['get_header', 'wp_head'])->each(function ($tag) {
        ob_start();
        do_action($tag);
        $output = ob_get_clean();
        remove_all_actions($tag);
        add_action($tag, function () use ($output) {
            echo $output;
        });
    });
    $data = collect(get_body_class())->reduce(function ($data, $class) use ($template) {
        return apply_filters("sage/template/{$class}/data", $data, $template);
    }, []);
    if ($template) {
        echo template($template, $data);
        return get_stylesheet_directory().'/index.php';
    }
    return $template;
}, PHP_INT_MAX);

/**
 * Render comments.blade.php
 */
add_filter('comments_template', function ($comments_template) {
    $comments_template = str_replace(
        [get_stylesheet_directory(), get_template_directory()],
        '',
        $comments_template
    );

    $data = collect(get_body_class())->reduce(function ($data, $class) use ($comments_template) {
        return apply_filters("sage/template/{$class}/data", $data, $comments_template);
    }, []);

    $theme_template = locate_template(["views/{$comments_template}", $comments_template]);

    if ($theme_template) {
        echo template($theme_template, $data);
        return get_stylesheet_directory().'/index.php';
    }

    return $comments_template;
}, 100);


function cc_mime_types($mimes) {
    $mimes['svg'] = 'image/svg+xml';
    return $mimes;
}
if(function_exists('get_field') && get_field('allow_svg','option')) {
    add_filter('mime_types',  __NAMESPACE__.'\\cc_mime_types');
}

add_action( 'pre_get_posts', function ($query) {
    if ($query->is_main_query() && !is_admin() && is_post_type_archive('companies')) {
        $query-> set('orderby' ,'title');
        $query-> set('order' , $title_order ? $title_order : 'ASC');
    }


    if ($query->is_main_query() && !is_admin() && is_post_type_archive('products')) {
        $category_products = $_GET['category-product'];
        $company_id = $_GET['company'];

        $date_order = $_GET['date-order'];
        

        if (empty($category_products) && empty($category_products) && empty($date_order)) return;
        
        if($company_id) {
            $meta_query = [
                [
                    'key'   => 'product_relation_with_company',
                    'value' => $company_id,
                    'compare' => 'LIKE',
                ]
            ];
        }

        if($category_products) {
            $tax_query = array(
                'tax_query' => array(
                    'taxonomy' => 'category_products',
                    'field' => 'slug',
                    'terms' => $category_products,
                ),
            );
        }

        
        $query-> set('post_type' ,'products');
        $query-> set('posts_status' ,'publish');
        $query-> set('orderby' ,'publish_date');
        $query-> set('order' , $date_order ? $date_order : 'DESC');
        if($category_products) {
            $query->set( 'tax_query', $tax_query );
        }
        if($company_id) {
            $query->set('meta_query', $meta_query);
        }
    }

    if ($query->is_main_query() && !is_admin() && is_post_type_archive('companies')) {
        $category_companies = $_GET['category-companies'];

        $title_order = $_GET['title-order'];

        if (empty($category_companies) && empty($title_order)) return;

        if($category_companies) {
            $tax_query = array(
                'tax_query' => array(
                    'taxonomy' => 'category_companies',
                    'field' => 'slug',
                    'terms' => $category_companies,
                ),
            );
        }

        $query-> set('post_type' ,'companies');
        $query-> set('posts_status' ,'publish');
        $query-> set('orderby' ,'title');
        $query-> set('order' , $title_order ? $title_order : 'ASC');
        if($category_companies) {
            $query->set( 'tax_query', $tax_query );
        }
    }
});

add_action( 'pre_get_posts', function ($query) {
    if ($query->is_main_query() && !is_admin() && is_post_type_archive('technical_events')) {
        $tax_query = array(
            'tax_query' => array(
                'taxonomy' => 'category_technical_events',
                'field' => 'slug',
                'terms' => 'eventi-passati',
            ),
        );
        $query->set( 'tax_query', $tax_query );
    }
});

add_filter('use_block_editor_for_post', function ($use_block_editor, $post) {
    if($post->post_type == 'page') {
        return true;
    }

    return false;
}, 10, 2);

add_filter('wpseo_breadcrumb_single_link_info', function($crumb) {
    $word_limit = 5;
    $crumb['text'] = wp_trim_words($crumb['text'], $word_limit);

    return $crumb;
});