@php
  /**
   * Testimonial Block Template.
   *
   * @param   array $block The block settings and attributes.
   * @param   string $content The block inner HTML (empty).
   * @param   bool $is_preview True during AJAX preview.
   * @param   (int|string) $post_id The post ID this block is saved to.
   */

  // Create id attribute allowing for custom "anchor" value.
  $id = 'thor-posts-featured' . $block['id'];
  if( !empty($block['anchor']) ) {
    $id = $block['anchor'];
  }

  // Create class attribute allowing for custom "className" and "align" values.
  $className = 'thor-'.$block['slug'];

  if( !empty($block['className']) ) {
    $className .= ' ' . $block['className'];
  }
  if( !empty($block['align']) ) {
    $className .= ' align' . $block['align'];
  }

  $args_last_by_companies = [
    'post_status'    => 'publish',
    'posts_per_page' => 2,
    'tax_query' => array(
      array(
        'taxonomy' => 'category',
        'field'    => 'slug',
        'terms'    => 'dalle-aziende'
      )
    )
  ];
  $last_by_companies = get_posts($args_last_by_companies);

  $args_last_technical_articles = [
  'post_status'    => 'publish',
  'posts_per_page' => 1,
  'tax_query' => array(
    array(
      'taxonomy' => 'category',
      'field'    => 'slug',
      'terms'    => 'articoli-tecnici'
    )
  )
  ];
  $last_technical_articles = get_posts($args_last_technical_articles);

  $banner_leaderboard_2 = get_field('banner_leaderboard_2', 'option');

@endphp

<div id="{!! esc_attr($id) !!}" class="{!! esc_attr($className); !!}">
  <div class="post-hero">
    <div class="featured-wrapper">
      <div class="featured-big">
        @foreach ($last_technical_articles as $featured)
          @php
            $post_badge = get_field('lioit_post_badge_text', $featured->ID);
            $term = get_the_terms( $featured->ID, 'category' );
          @endphp
          <article class="post-teaser">
            <span class="post-badge">
              @if ($post_badge)
                {!! $post_badge !!}
              @else
                {!! $term[0]->name !!}
              @endif
              <time
                class="updated mobile"
                datetime="{{ get_post_time('d F o', true) }}">
                {{ get_the_date('d F o', $featured->ID) }}
              </time>
            </span>
            @if (has_post_thumbnail($featured->ID))
              <figure>
                <a href="{{ get_permalink($featured->ID) }}" title="{!! get_the_title($featured->ID) !!}">
                  <img
                    class="lazy"
                    src="{!! get_the_post_thumbnail_url($featured->ID, 'mini') !!}"
                    data-src="{!! get_the_post_thumbnail_url($featured->ID, 'large') !!}"
                  />
                </a>
              </figure>
            @endif
            
            <div class="teaser-content">
              <header>
                <a href="{{ get_permalink($featured->ID) }}" title="{!! get_the_title($featured->ID) !!}">
                  <h2>
                    {!! get_the_title($featured->ID) !!}
                  </h2>
                </a>
              </header>

              <div class="teaser-info">
                <time
                  class="updated"
                  datetime="{{ get_post_time('d F o', true) }}">
                  {{ get_the_date('d F o', $featured->ID) }}
                </time>
                <div class="entry-summary">
                  {!! get_the_excerpt($featured->ID); !!}
                </div>
              </div>
            </div>

          </article>
        @endforeach
      </div>

      <div class="featured-small">
        @foreach ($last_by_companies as $featured)
          @php
            $post_badge = get_field('lioit_post_badge_text', $featured->ID);
          @endphp
          <article class="post-teaser">
            <span class="post-badge">
                {!! $post_badge !!}
                <time
                  class="updated mobile"
                  datetime="{{ get_post_time('d F o', true) }}">
                  {{ get_the_date('d F o', $featured->ID) }}
                </time>
              </span>
            <div class="mobile">
              @if (has_post_thumbnail($featured->ID))
                <figure>
                  <a href="{{ get_permalink($featured->ID) }}" title="{!! get_the_title($featured->ID) !!}">
                    <img
                      class="lazy"
                      src="{!! get_the_post_thumbnail_url($featured->ID, 'mini') !!}"
                      data-src="{!! get_the_post_thumbnail_url($featured->ID, 'large') !!}"
                    />
                  </a>
                </figure>
              @endif
              
              <header>
                <a href="{{ get_permalink($featured->ID) }}" title="{!! get_the_title($featured->ID) !!}">
                  <h2>
                    {!! get_the_title($featured->ID) !!}
                  </h2>
                </a>
              </header>
              <time
                class="updated"
                datetime="{{ get_post_time('d F o', true) }}">
                {{ get_the_date('d F o', $featured->ID) }}
              </time>
            </div>
          </article>
        @endforeach
      </div>
    </div>

    @include('partials.last-news-aside', ['last_news_aside' => $featured_home_post])
  </div>

  <div class="banner-leaderboard-2">{!! $banner_leaderboard_2 !!}</div>
</div>