@php
  /**
   * Testimonial Block Template.
   *
   * @param   array $block The block settings and attributes.
   * @param   string $content The block inner HTML (empty).
   * @param   bool $is_preview True during AJAX preview.
   * @param   (int|string) $post_id The post ID this block is saved to.
   */

  // Create id attribute allowing for custom "anchor" value.
  $id = 'thor-posts-slider' . $block['id'];
  if( !empty($block['anchor']) ) {
    $id = $block['anchor'];
  }

  // Create class attribute allowing for custom "className" and "align" values.
  $className = 'thor-'.$block['slug'];

  if( !empty($block['className']) ) {
    $className .= ' ' . $block['className'];
  }
  if( !empty($block['align']) ) {
    $className .= ' align' . $block['align'];
  }

  $category_teaser = get_field('category_teaser');
  $section_title = get_field('section_title');
  $archive_link = get_field('archive_link');

  $last_posts_category = [
  'post_status' => 'publish',
  'posts_per_page' => 12,
  'orderby' => 'date',
  'category_name' => $category_teaser[0]->slug,
  ];
  $last_posts_category = get_posts($last_posts_category);
  
  $banner_leaderboard_4 = get_field('banner_leaderboard_4', 'option');
@endphp

<div class="banner-leaderboard-4">{!! $banner_leaderboard_4 !!}</div>

<div id="{!! esc_attr($id) !!}" class="{!! esc_attr($className); !!}">

  <div class="slider-header">
    <div class="section-header">
      <div class="section-divider"></div>
      <div class="flex justify-between">
        <h3 class="section-title">{!! $section_title !!}</h3>
        <a class="link-archive" href="{!! $archive_link['url'] !!}">
          {!! $archive_link['title'] !!}
          @svg('images/arrow-right-archive.svg')
        </a>
      </div>
    </div>
  </div>

  <div class="bg-gray-100">
    <div class="swiper-container slider-home">
      <div class="swiper-wrapper">
        @foreach ($last_posts_category as $slide)
          @php
            $post_badge = get_field('lioit_post_badge_text', $slide->ID);
            $term = get_the_terms( $slide->ID, 'category' );
          @endphp
          <article class="swiper-slide post-teaser">
            <span class="post-badge">
              @if ($post_badge)
                  {!! $post_badge !!}
              @else
                {!! $term[0]->name !!}
              @endif
              <time
                class="updated mobile"
                datetime="{{ get_post_time('d F o', true) }}">
                {{ get_the_date('d F o', $featured->ID) }}
              </time>
            </span>
            @if (has_post_thumbnail($slide->ID))
              <figure>
                <a href="{{ get_permalink($slide->ID) }}" title="{!! get_the_title($slide->ID) !!}">
                  <img
                    class="lazy"
                    src="{!! get_the_post_thumbnail_url($slide->ID, 'mini') !!}"
                    data-src="{!! get_the_post_thumbnail_url($slide->ID, 'large') !!}"
                  />
                </a>
              </figure>
            @endif
            
            <header>
              <a href="{{ get_permalink($slide->ID) }}" title="{!! get_the_title($slide->ID) !!}">
                <h2>
                  {!! get_the_title($slide->ID) !!}
                </h2>
              </a>
            </header>
            {{-- <div class="entry-summary">
              @php
                get_the_excerpt($slide->ID);
              @endphp
            </div> --}}
            <time
              class="updated"
              datetime="{{ get_post_time('d F o', true) }}">
              {{ get_the_date('d F o', $slide->ID) }}
            </time>
          </article>
        @endforeach
      </div>

      <div class="pagination-wrapper">
        <div class="custom-button-prev">
          <img src="@asset('images/chevron-left.svg')" alt="{{ __('circle-chevron-left', 'thor') }}">
        </div>
        <div class="swiper-pagination"></div>
        <div class="custom-button-next">
          <img src="@asset('images/chevron-right.svg')" alt="{{ __('circle-chevron-right', 'thor') }}">
        </div>
      </div>
    </div>
  </div>
</div>

<div id="{!! esc_attr($id) !!}" class="{!! esc_attr($className); !!} alignfull mobile">
  <div class="slider-header">
    <div class="section-header">
      <div class="section-divider"></div>
      <div class="flex justify-between">
        <h3 class="section-title">{!! $section_title !!}</h3>
        <a class="link-archive" href="{!! $archive_link['url'] !!}">
          {!! $archive_link['title'] !!}
          @svg('images/arrow-right-archive.svg')
        </a>
      </div>
    </div>
  </div>

  <div class="bg-gray-100">
   <div class="title-section-mobile px-4">
      <div class="section-divider"></div>
      <div class="flex justify-between">
        <h3 class="section-title">{!! $section_title !!}</h3>
      </div>
    </div>

    <div class="swiper-container slider-home">
      <div class="swiper-wrapper">
        @foreach ($last_posts_category as $key => $slide)
          @php
            $post_badge = get_field('lioit_post_badge_text', $slide->ID);
            $term = get_the_terms( $slide->ID, 'category' );
          @endphp

          @if ($key % 3 == 0) 
              <div class = "swiper-slide">
          @endif

          <article class="post-teaser">
            <span class="post-badge">
              @if ($post_badge)
                {!! $post_badge !!}
              @else
                {!! $term[0]->name !!}
              @endif
              <time
                class="updated mobile"
                datetime="{{ get_post_time('d F o', true) }}">
                {{ get_the_date('d F o', $featured->ID) }}
              </time>
            </span>
            <div class="teaser-mobile">
              @if (has_post_thumbnail($slide->ID))
                <figure>
                  <a href="{{ get_permalink($slide->ID) }}" title="{!! get_the_title($slide->ID) !!}">
                    <img
                      class="lazy"
                      src="{!! get_the_post_thumbnail_url($slide->ID, 'mini') !!}"
                      data-src="{!! get_the_post_thumbnail_url($slide->ID, 'large') !!}"
                    />
                  </a>
                </figure>
              @endif

              <div>
                <header>
                  <a href="{{ get_permalink($slide->ID) }}" title="{!! get_the_title($slide->ID) !!}">
                    <h2>
                      {!! get_the_title($slide->ID) !!}
                    </h2>
                  </a>
                </header>
                <time
                  class="updated"
                  datetime="{{ get_post_time('d F o', true) }}">
                  {{ get_the_date('d F o', $slide->ID) }}
                </time>
              </div>
            </div>
          </article>

          @if ($key % 3 == 2) 
            </div>
          @endif
        @endforeach
      </div>

      <div class="pagination-wrapper">
        <div class="custom-button-prev">
          <img src="@asset('images/chevron-left.svg')" alt="{{ __('circle-chevron-left', 'thor') }}">
        </div>
        <div class="swiper-pagination"></div>
        <div class="custom-button-next">
          <img src="@asset('images/chevron-right.svg')" alt="{{ __('circle-chevron-right', 'thor') }}">
        </div>
      </div>
      <a class="link-archive" href="{!! $archive_link['url'] !!}">
        {!! $archive_link['title'] !!}
        @svg('images/arrow-right-archive.svg')
      </a>
    </div>
  </div>
</div>