@php
  $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
  $post_badge = get_field('lioit_post_badge_text', get_the_ID());
  $term = get_the_terms(get_the_ID(), 'category' );
@endphp
@extends('layouts.app')

@section('content')
  @include('partials.page-header')

  <div class="container">
    @if (!have_posts())
      <div class="alert alert-warning">
        {{ __('Sorry, no results were found.', 'thor') }}
      </div>
      {!! get_search_form(false) !!}
    @else

    @if ($paged == 1)
      <div class="big-posts-wrapper">
        <div class="w-full lg__w-1/2 big-teaser-container">
          @php the_post() @endphp
          
          @php
            $post_badge = get_field('lioit_post_badge_text', $featured->ID);
          @endphp
          <div class="featured-big">
          <article class="post-teaser">
            <span class="post-badge">
              @if ($post_badge)
                {!! $post_badge !!}
              
              @endif
              <time
                class="updated mobile"
                datetime="{{ get_post_time('d F o', true) }}">
                {{ get_the_date('d F o', $featured->ID) }}
              </time>
            </span>
            @if (has_post_thumbnail())
              <figure>
                <a href="{{ get_permalink() }}" title="{!! get_the_title() !!}">
                  <img
                    class="lazy"
                    src="{!! get_the_post_thumbnail_url(get_the_ID(), 'large') !!}"
                    data-src="{!! get_the_post_thumbnail_url(get_the_ID(), 'large') !!}"
                  />
                </a>
              </figure>
            @endif
            
            <div class="teaser-content">
              <header>
                <a href="{{ get_permalink() }}" title="{!! get_the_title() !!}">
                  <h2>
                    {!! get_the_title() !!}
                  </h2>
                </a>
              </header>

              <div class="teaser-info">
                <time
                  class="updated"
                  datetime="{{ get_post_time('d F o', true) }}">
                  {{ get_the_date('d F o', ) }}
                </time>
                <div class="entry-summary">
                  {!! get_the_excerpt(); !!}
                </div>
              </div>
            </div>
          </article>
        </div>

        </div>
          <div class="w-full lg__w-1/2 big-teaser-container">
            @php the_post() @endphp
            @php
              $post_badge = get_field('lioit_post_badge_text', $featured->ID);
            @endphp
            <article class="post-teaser">
              <span class="post-badge">
                @if ($post_badge)
                  {!! $post_badge !!}
                @else
                  {!! $term[0]->name !!}
                @endif
                <time
                  class="updated mobile"
                  datetime="{{ get_post_time('d F o', true) }}">
                  {{ get_the_date('d F o', $featured->ID) }}
                </time>
              </span>
              @if (has_post_thumbnail())
                <figure>
                  <a href="{{ get_permalink() }}" title="{!! get_the_title() !!}">
                    <img
                      class="lazy"
                      src="{!! get_the_post_thumbnail_url(get_the_ID(), 'large') !!}"
                      data-src="{!! get_the_post_thumbnail_url(get_the_ID(), 'large') !!}"
                    />
                  </a>
                </figure>
              @endif
              
              <div class="teaser-content">
                <header>
                  <a href="{{ get_permalink() }}" title="{!! get_the_title() !!}">
                    <h2>
                      {!! get_the_title() !!}
                    </h2>
                  </a>
                </header>

                <div class="teaser-info">
                  <time
                    class="updated"
                    datetime="{{ get_post_time('d F o', true) }}">
                    {{ get_the_date('d F o', ) }}
                  </time>
                  <div class="entry-summary">
                    {!! get_the_excerpt(); !!}
                  </div>
                </div>
              </div>
            </article>
          </div>
        </div>
      @endif

      <div class="content-wrapper archive">
        <div class="posts-wrapper row">
          @while (have_posts())
            @php the_post() @endphp
              @include('partials.teaser-posts-category')
          @endwhile
        </div>

        <div class="adv-wrapper">
          @include('partials.adv-box-1')
          @include('partials.adv-box-2')
          @include('partials.adv-box-3')
          @include('partials.adv-halfpage')
        </div>
      </div>
    @endif

    @if(function_exists('wp_pagenavi'))
      {!!  wp_pagenavi(); !!}
    @endif

  </div><!--container-->
@endsection
