@php
  $cta_newsletter_header = get_field('cta_newsletter_header', 'option');
  $cta_shop_header = get_field('cta_shop_header', 'option');
  $cart_url = wc_get_cart_url();
  $account_url = get_permalink( get_option('woocommerce_myaccount_page_id') );
@endphp

<header class="main-header">
  <div class="header-top">
    <div class="left-items">
      <button id="overlay-menu-toggle" class="hamburger hamburger--collapse" type="button">
        <span class="hamburger-box">
          <span class="hamburger-inner"></span>
        </span>
      </button>
      @include('partials.search-form')
    </div>

    <a class="brand" href="{{ home_url('/') }}">
      @svg('images/logo-nt24.svg')
    </a>

    <div class="right-items">
      <a href="{!! $cta_shop_header['url'] !!}" class="shop-link" target="{!! $cta_shop_header['target'] !!}">
        {!! $cta_shop_header['title'] !!}
      </a>

      <a class="user" href="{{ $account_url }}">
        @svg('images/user-icon.svg')
      </a>

      <a class="cart" href="{{ $cart_url }}">
        @svg('images/cart-icon.svg')
      </a>
    </div>
  </div>

  <div class="divider"></div>

  <div class="header-bottom">
    <div class="navbar">
      @if (has_nav_menu('primary_navigation'))
        {!! wp_nav_menu(['theme_location' => 'primary_navigation', 'menu_class' => 'nav']) !!}
      @endif
    </div>

    @if ($cta_newsletter_header)
      <a href="{!! $cta_newsletter_header['url'] !!}" class="newsletter" target="{!! $cta_newsletter_header['target'] !!}">
        {!! $cta_newsletter_header['title'] !!}
        <span>@svg('images/newsletter-icon.svg')</span>
      </a>
    @endif
  </div>
</header>