@php
  $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;

  $args_ongoing_events = [
    'post_type' => 'technical_events',
    'post_status' => 'publish',
    'tax_query' => [
        [
            'taxonomy' => 'category_technical_events',
            'field'    => 'slug',
            'terms'    => 'eventi-in-corso',
        ],
    ],
  ];
  $ongoing_events = get_posts($args_ongoing_events);
@endphp
@extends('layouts.app')

@section('content')
  @include('partials.page-header')

  <div class="container">
    @if (!have_posts())
      <div class="alert alert-warning">
        {{ __('Sorry, no results were found.', 'thor') }}
      </div>
      {!! get_search_form(false) !!}
    @else
      <div class="content-wrapper">
        <div class="posts-wrapper">
          @while (have_posts())
            @php the_post() @endphp
           
              @if ($paged == 1)
                <div class="ongoing-events">
                  @if ($ongoing_events)
                    @foreach ($ongoing_events as $event)
                      <div class="ongoing-events">
                        @include('partials.teaser-technical-event-ongoing')
                      </div>
                    @endforeach
                  @else
                    <div class="no-events">
                      {!! __('Attualmente non sono in programma nuovi eventi.', 'thor') !!}</h3>
                    </div>
                  @endif
                </div>
              @endif

            
              <div class="concluded-events">
                 <h3 class="title-section-event">{!! __('Eventi passati', 'thor') !!}</h3>
                @include('partials.teaser-technical-event')
              </div>
          @endwhile
        </div>

        <div class="adv-wrapper">
          @include('partials.adv-box-1')
          @include('partials.adv-box-2')
          @include('partials.adv-box-3')
          @include('partials.adv-halfpage')
        </div>
      </div>
    @endif

    @if(function_exists('wp_pagenavi'))
      {!!  wp_pagenavi(); !!}
    @endif

  </div><!--container-->
@endsection
