@php
  $related_company_id = get_field('product_relation_with_company', get_the_ID());
  $related_company_name = get_the_title($related_company_id[0]);
  $related_company_website = get_field('website_url', $related_company_id[0]);
  $related_company_contact = get_permalink($related_company_id[0]);
  $link_find_out_more = get_field('link_find_out_more', get_the_ID());
  $post_type = get_post_type( get_the_ID() );
  $archive_link = get_post_type_archive_link($post_type);
  $terms_products = get_the_terms( $last_post->ID, 'category_products' );

  $args_related_products = [
    'post_type' => get_post_type( get_the_ID() ),
    'post_status' => 'publish',
    'post__not_in' => [get_the_ID()],
    'posts_per_page' => 3,
    'meta_query' => [
      [
        'key'   => 'product_relation_with_company',
        'value' => $related_company_id[0],
        'compare' => 'LIKE',
      ],
    ],
  ];
  $related_products = get_posts($args_related_products);
@endphp

<article {!! post_class('single-post-wrapper') !!}>
  <div class="wrapper-back-to-archive">
    <a href="{{ $archive_link }}" class="back-to-archive">
      {!! __('Torna ai prodotti', 'thor') !!}
      @svg('images/arrow-teaser-archive.svg')
    </a>
  </div>

  @include('partials/page-header')

  <div class="container">

    <div class="single-post-inner clearfix">
      <div class="post-content-wrapper">
        <div class="content">
          <div class="product-info-wrapper">
            <figure class="main-image">
              <a href="{!! get_the_post_thumbnail_url(get_the_ID(), 'full') !!}">
                <img
                  class="lazy"
                  src="{!! get_the_post_thumbnail_url(get_the_ID(), 'thumbnail') !!}"

                  data-src="{!! get_the_post_thumbnail_url(get_the_ID(), 'large') !!}"

                />
              </a>
            </figure>

            <div class="product-info">
              <h1 class="title">{!! App::title() !!}</h1>
              @if ($related_company_website['url'])
                <a href="{!!  $related_company_website['url'] !!}" target="{!!  $related_company_website['target'] !!}" class="company">{!!  $related_company_website['title'] !!}</a>
              @endif

              @if ($related_company_contact)
                <a href="{!!  $related_company_contact !!}" class="info-company">{!! __("Chiedi informazioni all'azienda", 'thor') !!}</a>
              @endif

              @if ($link_find_out_more['url'])
                <a href="{!!  $link_find_out_more['url'] !!}" target="{!!  $link_find_out_more['target'] !!}" class="find-more">{!!  $link_find_out_more['title'] !!}</a>
              @endif
            </div>
          </div>

          @if (the_content())
            <h3 class="content-title">{!! __("Descrizione prodotto", 'thor') !!}</h3>
            @php the_content() @endphp
          @endif

          @if ($related_products)
            <div class="related-products">
              <div class="section-divider"></div>
              <h3 class="title-section">{!! __('Altri prodotti di', 'thor') !!} {!! $related_company_name !!}</h3>
              <div class="teaser-wrapper">
                @foreach ($related_products as $product)
                  <article class="post-teaser">
                    <div class="content-left">
                      @if (has_post_thumbnail($product->ID))
                        <figure>
                          <a href="{{ get_permalink($product->ID) }}" title="{!! get_the_title($product->ID) !!}">
                            <img
                              class="lazy"
                              src="{!! get_the_post_thumbnail_url($product->ID, 'mini') !!}"
                              data-src="{!! get_the_post_thumbnail_url($product->ID, 'large') !!}"
                            />
                          </a>
                        </figure>
                      @endif
                    </div>
                    
                    <div class="content-right">
                      <header>
                        <a href="{{ get_permalink($product->ID) }}" title="{!! get_the_title($product->ID) !!}">
                          <h2>
                            {!! get_the_title($product->ID) !!}
                          </h2>
                        </a>
                      </header>

                      <div class="button-wrapper">
                        @foreach ($terms_products as $term)
                          <a href="{{ get_term_link($term->term_id) }}" title="{!! $term->name !!}">
                            <span class="post-badge">{!! $term->name !!}</span>
                          </a>
                        @endforeach

                        <a href="{{ get_permalink($product->ID) }}" title="{!! get_the_title($product->ID) !!}" class="button-teaser-archive">
                          <h5 class="show-product">{!! __('Vedi prodotto', 'thor') !!}</h5>
                          <span>
                            @svg('images/arrow-teaser-archive.svg')
                          </span>
                        </a>
                      </div>
                    </div>
                  </article>
                @endforeach
              </div>
            </div>
          @endif
        </div>
      </div>

     
    </div><!--single-post-inner-->
  </div><!--container-->
</article>
