@php
/**
 * The template for displaying product content in the single-product.php template
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-single-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.6.0
 */

  $terms = get_the_terms( get_the_ID(), 'product_cat' );

  $args_related_products = [
    'post_type' => 'product',
    'post_status' => 'publish',
    'post__not_in' => [get_the_ID()],
    'posts_per_page' => 3,
    'tax_query' => [
      [
        'taxonomy'  => 'product_cat',
        'field'     => 'slug',
        'terms'     => [$terms[0]->slug],
        'operator'  => 'IN',
      ],
    ],
  ];
  $related_products = get_posts($args_related_products);

defined( 'ABSPATH' ) || exit;

global $product;

@endphp

@extends('layouts.app')

@section('content')
  @php

    if ( post_password_required() ) {
      echo get_the_password_form(); 
      return;
    }
  @endphp

  <div id="product-<?php the_ID(); ?>" <?php wc_product_class( '', $product ); ?>>
    @php
      do_action( 'woocommerce_before_single_product' );
    @endphp 

    <div class="info-top">
      <div class="container product-info-wrapper">
          @php
            /**
             * Hook: woocommerce_before_single_product_summary.
             *
             * @hooked woocommerce_show_product_sale_flash - 10
             * @hooked woocommerce_show_product_images - 20
             */
            do_action( 'woocommerce_before_single_product_summary' );
          @endphp

          <div class="summary entry-summary">
            @php
              /**
               * Hook: woocommerce_single_product_summary.
               *
               * @hooked woocommerce_template_single_title - 5
               * @hooked woocommerce_template_single_rating - 10
               * @hooked woocommerce_template_single_price - 10
               * @hooked woocommerce_template_single_excerpt - 20
               * @hooked woocommerce_template_single_add_to_cart - 30
               * @hooked woocommerce_template_single_meta - 40
               * @hooked woocommerce_template_single_sharing - 50
               * @hooked WC_Structured_Data::generate_product_data() - 60
               */

              
              do_action( 'woocommerce_single_product_summary' );
            @endphp
          </div>
      </div><!-- container -->
    </div>
    
    <div class="info-bottom">
      <h5 class="title-description">{!! __('Descrizione', 'thor') !!}</h5>
      <div class="single-product-content mobile">
        @php
          $product_data          = $product->get_data();
          $product_full_description = $product_data['description'];  
        @endphp

        {!! $product_full_description !!}
      </div>

      <div class="summary entry-summary">
        @php
          /**
           * Hook: woocommerce_single_product_summary.
           *
           * @hooked woocommerce_template_single_title - 5
           * @hooked woocommerce_template_single_rating - 10
           * @hooked woocommerce_template_single_price - 10
           * @hooked woocommerce_template_single_excerpt - 20
           * @hooked woocommerce_template_single_add_to_cart - 30
           * @hooked woocommerce_template_single_meta - 40
           * @hooked woocommerce_template_single_sharing - 50
           * @hooked WC_Structured_Data::generate_product_data() - 60
           */

          
          do_action( 'woocommerce_single_product_summary' );
        @endphp
      </div>

      <div class="related-products">
        <div class="section-divider"></div>
        <h3 class="title-section">{!! __('Prodotti Correlati', 'thor') !!} {!! $related_company_name !!}</h3>
        @php
          do_action( 'woocommerce_after_single_product_summary' );
          remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_output_related_products', 20 );
        @endphp
      </div>
    </div>
  </div>


  @php
    do_action('get_sidebar', 'shop');
    do_action('get_footer', 'shop');
  @endphp
@endsection